<?php

namespace App\Http\Controllers\Admin\ContactQuery;

use App\Exports\ContactUsInquiry;
use App\Http\Controllers\Controller;
use App\Models\ContactQuery;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ContactQueryController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $query = ContactQuery::query();
        $service_type = request()->service_type;
        // $enquiries = ContactQuery::paginate(10);
        $search = request()->search;

        if ($service_type && $service_type != '') {
            $query->where('service_type', $service_type);
        }

        if ($search && $search != '') {
            $columns = ['first_name', 'last_name', 'phone_number', 'email', 'service_type'];
            foreach ($columns as $column) {
                $query->orWhere($column, 'LIKE', '%' . $search . '%');
            }
        }

        $enquiries = $query->latest()->paginate(10)->appends(request()->query());

        return view('Admin.ContactQuery.index', compact('enquiries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $enquiry = ContactQuery::find($id);
        return view('Admin.ContactQuery.show', compact('enquiry'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $query = ContactQuery::find($id);
        $query->delete();

        return redirect()->route('admin.contact-us-query.index');
    }

    public function export()
    {

       
        return Excel::download(new ContactUsInquiry, 'contact-us-inquires.xlsx');
    }
}
