<?php

namespace App\Http\Controllers\Admin\Cruise;

use App\Http\Controllers\Controller;
use App\Models\TopCruisePage;
use Illuminate\Http\Request;

class TopCruisePageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $content = TopCruisePage::first();
        return view('Admin.Cruises.TopCruisePage.index', compact('content'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);  
        $banner = $request->file('banner')->store('top-cruise/banner', 'public');
        $image = $request->file('image')->store('top-cruise/image', 'public');
        $content = new TopCruisePage;
        $content->title = $request->title;
        $content->banner = $banner;
        $content->image_title = $request->image_title;
        $content->image = $image;
        $content->description = $request->description;
        $content->meta_title = $request->meta_title;
        $content->meta_keywords = $request->meta_keywords;
        $content->meta_description = $request->meta_description;
        $content->save();

        return redirect()->route('admin.top-cruise-page.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $content = TopCruisePage::find($id);
        $content->title = $request->title;
        if ($request->hasFile('banner')) {
            $banner_img = $request->file('banner')->store('top-cruise/banner', 'public');
            $content->banner = $banner_img;
        }
        $content->image_title = $request->image_title;
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('top-cruise/image', 'public');
            $content->image = $image;
        }
        $content->description = $request->description;
        $content->meta_title = $request->meta_title;
        $content->meta_keywords = $request->meta_keywords;
        $content->meta_description = $request->meta_description;
        $content->save();

        return redirect()->route('admin.top-cruise-page.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
