<?php

namespace App\Http\Controllers\Admin\Cruise;

use App\Http\Controllers\Controller;
use App\Models\TopCruisePort as ModelsTopCruisePort;
use App\Models\TopCruisePortLocation;
use Illuminate\Http\Request;

class TopCruisePort extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contents = ModelsTopCruisePort::paginate(10);
        return view('Admin.Cruises.TopCruisePorts.index', compact('contents'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.Cruises.TopCruisePorts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $content = new ModelsTopCruisePort();
        $content->port_name = $request->port_name;
        $content->save();

        foreach ($request->file('guide_image') as $key => $image) {
            $image = $image->store('TopCruise/image', 'public');
            $destination_content = new TopCruisePortLocation();
            $destination_content->port_id  = $content->id;
            $destination_content->port_location_name	 = $request->guide_title[$key];
            $destination_content->image = $image;
            $destination_content->description = $request->guide_description[$key];
            $destination_content->save();
        }

        return redirect()->route('admin.top-cruise-ports.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $content = ModelsTopCruisePort::find($id);
        $content->delete();
        return redirect()->route('admin.top-cruise-ports.index');
    }
}
