<?php

namespace App\Http\Controllers\Admin\Destination;

use App\Http\Controllers\Controller;
use App\Models\AllDestination;
use Illuminate\Http\Request;

class AllDestinationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $content = AllDestination::first();
        return view('Admin.AllDestinations.index', compact('content'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);

        $banner = $request->file('banner')->store('AllDestination/banner', 'public');
        $image = $request->file('image')->store('AllDestination/image', 'public');

        $content = new AllDestination();
        $content->title = $request->title;
        $content->banner = $banner;
        $content->header_title = $request->header_title;
        $content->description = $request->description;
        $content->image = $image;
        $content->meta_title = $request->meta_title;
        $content->meta_description = $request->meta_description;
        $content->meta_keywords = $request->meta_keywords;
        $content->save();

        return redirect()->route('admin.all-destination.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $content = AllDestination::find($id);
        $content->title = $request->title;
        // $content->banner = $banner;
        if ($request->hasFile('banner')) {
            $banner = $request->file('banner')->store('AllDestination/banner', 'public');
            $content->banner = $banner;
        }
        $content->header_title = $request->header_title;
        $content->description = $request->description;
        // $content->image = $image;
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('AllDestination/image', 'public');
            $content->image = $image;
        }
        $content->meta_title = $request->meta_title;
        $content->meta_description = $request->meta_description;
        $content->meta_keywords = $request->meta_keywords;
        $content->save();

        return redirect()->route('admin.all-destination.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

  
}
