<?php

namespace App\Http\Controllers\Admin\Destination;

use App\Http\Controllers\Controller;
use App\Models\Destination;
use App\Models\DestinationExperience;
use App\Models\DestinationGuide;
use Illuminate\Cache\RedisTaggedCache;
use Illuminate\Http\Request;

class DestinationController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contents = Destination::paginate(10);
        return view('Admin.Destinations.index', compact('contents'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.Destinations.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $banner = $request->file('banner')->store('Destination/Banner', 'public');
        $destination_image = $request->file('destination_image')->store('Destination/destination_image', 'public');
        // dd($request->all());
        $content = new Destination();
        $content->title = $request->title;
        $content->slug = $request->slug;
        $content->banner = $banner;
        $content->destination_name = $request->title;
        $content->destination_image = $destination_image;
        $content->destination_description = $request->description;
        $content->save();

        foreach ($request->file('guide_image') as $key => $image) {
            $image = $image->store('Destination/guide_image', 'public');
            $destination_content = new DestinationGuide();
            $destination_content->destination_id  = $content->id;
            $destination_content->title = $request->guide_title[$key];
            $destination_content->image = $image;
            $destination_content->description = $request->guide_description[$key];
            $destination_content->links = $request->guide_link[$key];
            $destination_content->position = $request->guide_position[$key];
            $destination_content->save();
        }

        foreach ($request->file('experience_image') as $key => $image) {
            $image = $image->store('Destination/experience_image', 'public');
            $experience_content = new DestinationExperience();
            $experience_content->destination_id  = $content->id;
            $experience_content->title = $request->experience_title[$key];
            $experience_content->image = $image;
            $experience_content->description = $request->experience_description[$key];
            $experience_content->links = $request->experience_link[$key];
            $experience_content->position = $request->experience_position[$key];
            $experience_content->save();
        }

        return redirect()->route('admin.destination.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $destination = Destination::find($id);
        $destination_contents = DestinationGuide::where('destination_id', $id)->get();
        $experience_contents = DestinationExperience::where('destination_id', $id)->get();
        // dd($destination,  $destination_contents, $experience_contents);
        return view('Admin.Destinations.edit', compact('destination', 'destination_contents', 'experience_contents'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request);
        $content = Destination::find($id);
        $content->title = $request->title;
        $content->slug = $request->slug;
        if ($request->hasFile('banner')) {
            $banner = $request->file('banner')->store('Destinations/banner', 'public');
            $content->banner = $banner;
        }
        $content->destination_name = $request->title;
        if ($request->hasFile('destination_image')) {
            $destination_image = $request->file('destination_image')->store('Destinations/destination_image', 'public');
            $content->destination_image = $destination_image;
        }
        $content->destination_description = $request->description;
        $content->save();

       
        foreach ($request->guide_id as $key => $id) {
            $destination_content = DestinationGuide::find($id);
            $destination_content->destination_id  = $request->guide_destination_id[$key];
            $destination_content->title = $request->guide_title[$key];
            if ($request->hasFile('guide_image')) {
                $image = $request->file('destination_image')->store('Destinations/destination_image', 'public');
                $content->guide_image = $image;
            }
            $destination_content->description = $request->guide_description[$key];
            $destination_content->links = $request->guide_link[$key];
            $destination_content->position = $request->guide_position[$key];
            $destination_content->save();
        }

        
        foreach ($request->experience_id as $key => $id) {
            $experience_content =  DestinationExperience::find($id);
            $experience_content->destination_id  = $request->experience_destination_id[$key];
            $experience_content->title = $request->experience_title[$key];
            if ($request->hasFile('experience_image')) {
                $image = $request->file('experience_image')->store('Destinations/experience_image', 'public');
                $content->experience_image = $image;
            }
            $experience_content->description = $request->experience_description[$key];
            $experience_content->links = $request->experience_link[$key];
            $experience_content->position = $request->experience_position[$key];
            $experience_content->save();
        }

        return redirect()->route('admin.destination.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $destination = Destination::find($id);
        $destination->delete();

        return redirect()->route('admin.destination.index');
    }
}
