<?php

namespace App\Http\Controllers\Admin\FlightForm;

use App\Exports\FlightFormExport;
use App\Http\Controllers\Controller;
use App\Models\FligtForm;
use App\Models\Location;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class FlightFormController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $query = FligtForm::query();
        $inquires = FligtForm::paginate(10);
        $locations = Location::all();

        $location = request()->location_id;
        $search = request()->search;

        if($location && $location != ''){
            $query->where('location_id',$location);
        }

        if($search && $search != '')
        {
            $columns = ['leaving_from', 'going_to', 'email'];
            foreach($columns as $column){
                $query->orWhere($column, 'LIKE', '%' . $search . '%');
            }
        }

        $inquires = $query->latest()->paginate(10)->appends(request()->query());
        
        return view('Admin.FlightForms.index', compact('inquires', 'locations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $inquiry = FligtForm::find($id);

        return view('Admin.FlightForms.show', compact('inquiry'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $inquiry = FligtForm::find($id);
        $inquiry->delete();

        return redirect()->route('admin.flight-forms.index');
    }

    public function export()
    {
        return Excel::download(new FlightFormExport, 'flight-form-export.xlsx');
    }
}
