<?php

namespace App\Http\Controllers\Admin\Home;

use App\Http\Controllers\Controller;
use App\Models\HomeDestinationForYou as ModelsHomeDestinationForYou;
use App\Models\HomeDestinationForYouLocation;
use Illuminate\Http\Request;

class HomeDestinationForYou extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contents = ModelsHomeDestinationForYou::orderBy('position','desc')->paginate(10);
        return view('Admin.HomeDestinationForYou.index', compact('contents'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $locations = HomeDestinationForYouLocation::all();
        return view('Admin.HomeDestinationForYou.create', compact('locations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $request->validate([
            'location_id'=>'required',
            'package_name'=>'required',
            'package_details'=>'required',
            'price'=>'required',
            'price_note'=>'required',
            'status'=>'required',
            'image'=>'required||max:2048',
            'image1'=>'required||max:2048',
            'pdf'=>'required|mimes:pdf|max:2048',
        ]);
        $image2='';
        $image = $request->file('image')->store('Home/DestinationForYou/image', 'public');
        $image1 = $request->file('image1')->store('Home/DestinationForYou/image1', 'public');
        if(!is_null($request->image2)){
            $image2 = $request->file('image2')->store('Home/DestinationForYou/image2', 'public');
        }
        $pdf = $request->file('pdf')->store('Home/DestinationForYou/pdf', 'public');

        $content = new ModelsHomeDestinationForYou();
        $content->location_id = $request->location_id;
        $content->package_name = $request->package_name;
        $content->package_details = $request->package_details;
        $content->image = $image;
        $content->image1 = $image1;
        $content->image2 = $image2;
        $content->price = $request->price;
        $content->price_note = $request->price_note;
        $content->pdf = $pdf;
        $content->status = $request->status;
        $content->position = $request->position;
        $content->save();

        return redirect()->route('admin.home-destination-for-you.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $locations = HomeDestinationForYouLocation::all();
        $content = ModelsHomeDestinationForYou::find($id);

        return view('Admin.HomeDestinationForYou.edit', compact('content', 'locations'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $content =  ModelsHomeDestinationForYou::find($id);
        $content->location_id = $request->location_id;
        $content->package_name = $request->package_name;
        $content->package_details = $request->package_details;
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('Home/DestinationForYou/image', 'public');
            $content->image = $image;
        }
        if ($request->hasFile('image1')) {
            $image1 = $request->file('image1')->store('Home/DestinationForYou/image1', 'public');
            $content->image1 = $image1;
        }
        if ($request->hasFile('image2')) {
            $image2 = $request->file('image2')->store('Home/DestinationForYou/image2', 'public');
            $content->image2 = $image2;
        }
        if ($request->hasFile('pdf')) {
            $pdf = $request->file('pdf')->store('Home/DestinationForYou/pdf', 'public');
            $content->pdf = $pdf;
        }
        $content->price = $request->price;
        $content->price_note = $request->price_note;
        $content->position = $request->position;
        $content->status = $request->status;
        $content->save();

        return redirect()->route('admin.home-destination-for-you.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $content = ModelsHomeDestinationForYou::find($id);
        $content->delete();

        return redirect()->route('admin.home-destination-for-you.index');
    }
}
