<?php

namespace App\Http\Controllers\Admin\IndianTouristDestination;

use App\Http\Controllers\Controller;
use App\Mail\AdminMail;
use App\Mail\IndianTourismMail;
use App\Models\AdminMails;
use App\Models\FormData;
use App\Models\IndianTourismQuery;
use App\Models\IndianTouristDestination;
use App\Models\Location;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class IndianTouristDestinationController extends Controller
{

    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contents = IndianTouristDestination::paginate(10);
        return view('Admin.IndianTourist.index', compact('contents'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.IndianTourist.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // dd($request);
        $request->validate([
            '*' => 'required',
        ]);

        $image = $request->file('image')->store('IndianTourism/image', 'public');
        $image1 = $request->file('image1')->store('IndianTourism/image1', 'public');
        $image2 = $request->file('image2')->store('IndianTourism/image2', 'public');
        $pdf = $request->file('pdf')->store('IndianTourism/pdf', 'public');

        $content = new IndianTouristDestination();
        $content->destination_name = $request->destination_name;
        $content->slug = $request->slug;
        $content->pdf = $pdf;
        $content->description = $request->description;
        $content->position = $request->position;
        $content->image = $image;
        $content->image1 = $image1;
        $content->image2 = $image2;
        $content->status = $request->status;
        $content->save();

        return redirect()->route('admin.indian-tourism.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $content = IndianTouristDestination::find($id);
        return view('Admin.IndianTourist.edit', compact('content'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            '*' => 'required',
        ]);


        $content = IndianTouristDestination::find($id);
        $content->destination_name = $request->destination_name;
        $content->slug = $request->slug;

        $content->description = $request->description;
        $content->position = $request->position;
        if ($request->hasFile('pdf')) {
            $pdf = $request->file('pdf')->store('IndianTourism/pdf', 'public');
            $content->pdf = $pdf;
        }
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('IndianTourism/image', 'public');
            $content->image = $image;
        }
        if ($request->hasFile('image1')) {
            $image1 = $request->file('image1')->store('IndianTourism/image1', 'public');
            $content->image1 = $image1;
        }
        if ($request->hasFile('image2')) {
            $image2 = $request->file('image2')->store('IndianTourism/image2', 'public');
            $content->image2 = $image2;
        }
        $content->status = $request->status;
        $content->save();

        return redirect()->route('admin.indian-tourism.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $content = IndianTouristDestination::find($id);
        $content->delete();

        return redirect()->route('admin.indian-tourism.index');
    }

    public function indian_tourism_form($id)
    {
        $id = $id;
        $content = IndianTouristDestination::where('id', $id)->first();

        // dd($content);
        return view('Frontend.Pages.IndianTourismForm.indian-tourism-form', compact('content'));
    }

    public function indian_tourism_form_page($id)
    {
        $id = $id;
        // $content = IndianTouristDestination::where('id', $id)->first();
        $locations = Location::all();
        // dd($content);
        return view('Frontend.Pages.IndianTourismForm.indian-tourism-form-page', compact('id', 'locations'));
    }

    public function indian_tourism_form_submit(Request $request)
    {
        $request->validate([
            'first_name' => 'required|regex:/^[a-zA-Z\s]+$/|max:255',
            'last_name' => 'required|regex:/^[a-zA-Z\s]+$/',
            'email' => 'required|email',
            'phone_number' => 'required',
            'comments' => 'nullable|regex:/^[a-zA-Z\s]+$/',
            'travelling_from' => 'nullable|regex:/^[a-zA-Z\s]+$/',
            'travelling_to' => 'nullable|regex:/^[a-zA-Z\s]+$/',
        ]);
        // dd($request);

        // $query = new IndianTourismQuery();
        // $query->india_dest_id  = $request->india_dest_id;
        // $query->first_name = $request->first_name;
        // $query->last_name = $request->last_name;
        // $query->email = $request->email;
        // $query->phone = $request->phone_number;
        // $query->message = $request->message;
        // $query->save();

        $query = FormData::create($request->all());

        $file_path = IndianTouristDestination::find($request->india_dest_id);

        //client mails
        Mail::to($request->email)->send(new IndianTourismMail($request,  $file_path->pdf));


        $location_mail = Location::find($request->location_id);
        $admin = explode(',', str_replace(" ", "", $location_mail->email_cc));

        $all_emails = array_merge($admin, [$location_mail->email]);


        Mail::to($all_emails)->send(new AdminMail($query, $file_path->destination_name));


        return redirect()->back()->with('message', 'FORM SUBMITTED SUCCESSFULLY, WE WILL GET BACK TO YOU SOON');
    }
}
