<?php

namespace App\Http\Controllers\Admin\Location;

use App\Http\Controllers\Controller;
use App\Models\Province;
use Illuminate\Http\Request;

class ProvinceController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    public function model()
    {
        return new Province;
    }
    public function index()
    {
        $provinces = $this->model()->paginate(10);
        return view('Admin.Province.index', compact('provinces'));
    }
    public function create()
    {
        return view('Admin.Province.create');
    }
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'position' => 'required|integer',
        ]);
        $province = $this->model()->create($request->all());
        return redirect()->route('admin.province.index')->with('success', 'Province added successfully');
    }
    public function edit($id)
    {
        $province = $this->model()->find($id);
        return view('Admin.Province.edit', compact('province'));
    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'position' => 'required|integer',
        ]);
        $province = $this->model()->find($id);
        $province->update($request->all());
        return redirect()->route('admin.province.index')->with('success', 'Province updated successfully');
    }
    public function destroy($id)
    {
        $province = $this->model()->find($id);
        $province->delete();
        return redirect()->route('admin.province.index')->with('success', 'Province deleted successfully');
    }
}
