<?php

namespace App\Http\Controllers\Admin\Location;

use App\Http\Controllers\Controller;
use App\Models\TravelLocation;
use Illuminate\Http\Request;

class TravelLocationController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    public function model()
    {
        return new TravelLocation;
    }
    public function index()
    {
        $locations = $this->model()->paginate(10);
        return view('Admin.travellocation.index', compact('locations'));
    }
    public function create()
    {
        return view('Admin.travellocation.create');
    }
    public function store(Request $request)
    {
        $request->validate([
            'location_name' => 'required|string',
            'location_description' => 'required|string',
        ]);
        $this->model()->create($request->all());
        return redirect()->route('admin.travel-location.index')->with('success', 'Location added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $location = $this->model()->findOrFail($id);
        return view('Admin.travellocation.edit', compact('location'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'location_name' => 'required|string',
            'location_description' => 'required|string',
        ]);
        $location = $this->model()->findOrFail($id);
        $location->update($request->all());
        return redirect()->route('admin.travel-location.index')->with('success', 'Location updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
