<?php

namespace App\Http\Controllers\Admin\TravelProfessional;

use App\Http\Controllers\Controller;
use App\Models\Location;
use App\Models\TravelProfessional;
use Illuminate\Http\Request;

class TravelProfessionalController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $locations = Location::all();

        $query = TravelProfessional::query();
        $location = request()->location_id;
        $search = request()->search;

        // $details = TravelProfessional::paginate(10);

        if ($location && $location != '') {
            $query->where('location_id', $location);
        }

        if($search && $search != '')
        {
            $columns = ['name', 'phone', 'email'];
            foreach($columns as $column){
                $query->orWhere($column, 'LIKE', '%' . $search . '%');
            }
        }

        $details = $query->latest()->paginate(10)->appends(request()->query());

        return view('Admin.TravelProfessional.index', compact('details', 'locations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $locations = Location::all();
        return view('Admin.TravelProfessional.create', compact('locations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $details = new TravelProfessional();
        $details->location_id  =  $request->location_id;
        $details->name  =  $request->name;
        $details->slug  =  $request->slug;
        $details->phone  =  $request->phone;
        $details->email  =  $request->email;
        $details->location  =  $request->location;
        $details->languages_known  =  $request->languages_known;
        $details->experience  =  $request->experience;
        $details->profession  =  $request->profession;
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('Travelprofessional/Image', 'public');
            $details->image  =  $image;
        }
        $details->status  =  $request->status;
        $details->no_quote_request  =  $request->no_quote_request;
        $details->save();

        return redirect()->route('admin.travel-professionals.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $locations = Location::all();
        $details = TravelProfessional::find($id);
        return view('Admin.TravelProfessional.edit', compact('details', 'locations'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $details = TravelProfessional::find($id);
        $details->location_id  =  $request->location_id;
        $details->name  =  $request->name;
        $details->slug  =  $request->slug;
        $details->phone  =  $request->phone;
        $details->email  =  $request->email;
        $details->location  =  $request->location;
        $details->languages_known  =  $request->languages_known;
        $details->experience  =  $request->experience;
        $details->profession  =  $request->profession;
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('Travelprofessional/Image', 'public');
            $details->image = $image;
        }
        $details->status  =  $request->status;
        if ($request->no_quote_request) {

            $details->no_quote_request = $request->no_quote_request;
        } else {

            $details->no_quote_request = 0;
        }
        $details->save();

        return redirect()->route('admin.travel-professionals.index');
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $details = TravelProfessional::find($id);
        $details->delete();

        return redirect()->route('admin.travel-professionals.index');
    }
}
