<?php

namespace App\Http\Controllers\Admin\Career;

use App\Exports\CareerInquiryExport;
use App\Http\Controllers\Controller;
use App\Models\Career;
use App\Models\Location;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class CareerQuery extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $query = Career::query();
        $enquiries = Career::latest()->paginate(10);
        $locations = Location::all();
        $search = request()->search;

        $location = request()->location_id;

        if ($location && $location != '') {
            $query->where('location_id', $location);
        }

        if ($search && $search != '') {
            $columns = ['first_name', 'last_name', 'phone_number', 'email', 'status_in_canada', 'position', 'city'];
            foreach ($columns as $column) {
                $query->orWhere($column, 'LIKE', '%' . $search . '%');
            }
        }

        $enquiries = $query->latest()->paginate(10)->appends(request()->query());

        return view('Admin.Careers.index', compact('enquiries', 'locations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $enquiry = Career::find($id);

        // dd($enquiry);
        return view('Admin.Careers.show', compact('enquiry'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $enquiry = Career::find($id);

        $enquiry->delete();

        return redirect()->route('admin.careers.index');
    }

    public function export()
    {

        dd(request()->search);
        
        $users = app(Career::class)->newQuery();

        if (request()->has('search') && !empty(request()->get('search'))) {
            $search = request()->query('search');
            $users->where(function ($query) use ($search) {
                $query->where('first_name', 'LIKE', "%{$search}%")
                    ->orWhere('last_name', 'LIKE', "%{$search}%")
                    ->orWhere('email', 'LIKE', "%{$search}%")
                    ->orWhere('mobile', 'LIKE', "%{$search}%");
            });
        }
        return view('users.index', compact('users'));

        // return Excel::download(new CareerInquiryExport, 'career-inquiry.xlsx');
    }
}
