<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Http\Requests\ContactUs;
use App\Mail\AdminMail;
use App\Mail\ContactAgency as MailContactAgency;
use App\Mail\ContactMail;
use App\Mail\IndianTourismMail;
use App\Models\AdminMails;
use App\Models\ContactAgency;
use App\Models\ContactQuery;
use App\Models\ContactUs as ModelsContactUs;
use App\Models\Location;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactUsController extends Controller
{
    public function contact_us()
    {
        $content = ModelsContactUs::first();
        return view('Frontend.Pages.ContactUs.ContactUs', compact('content'));
    }

    public function contact_us_query(Request $request)
    {
        $this->validate($request, [
            'first_name' => 'required|regex:/^[a-zA-Z\s]+$/|max:255',
            'last_name' => 'required|regex:/^[a-zA-Z\s]+$/',
            'phone_number' => 'required',
            'service_type' => 'nullable|regex:/^[a-zA-Z\s]+$/',
            'message' => 'nullable|regex:/^[a-zA-Z\s]+$/',
            'email' => 'required|email'
        ]);
        if ($request->faxonly) {
            return redirect()->back()->withSuccess('Your form has been submitted');
        }
        // dd($request->all());
        $query = new ContactQuery();
        $query->first_name = $request->first_name;
        $query->last_name = $request->last_name;
        // $query->full_name = $request->name;
        $query->email = $request->email;
        $query->phone_number = $request->phone_number;
        $query->service_type = $request->service_type;
        $query->message = $request->message;


        $query->save();

        //admin emails
        $country_codes = [
            '780','825','587','403','250','604','236','672','778',
            '431','204','506','428','709','867','902','782','807',
            '905','705','647','613','548','519','437','416','365',
            '343','289','249','226','438','450','514','418','367',
            '819','354','579','873','581','306','639'
        ];
        
        $phone = $request->phone_number;
        
        // Ensure phone is at least 3 characters long before extracting area code
        if (strlen($phone) >= 3) {
            $phone1 = substr($phone, 0, 3);
        
            if (in_array($phone1, $country_codes)) {
                if ($request->store_email) {
                    $location_email = [$request->store_email];
                } else {
                    $location_email = [];
                }
        
        
                $admin_email = AdminMails::latest()->first();
        
                if (!is_null($admin_email) && !is_null($admin_email->subscription)) {
                    $emails = explode(',', str_replace(" ", "", $admin_email->contact_us));
                } else {
                    $emails = [];
                }
        
                $admins = array_merge($emails, $location_email);
        
                if (count($admins) != 0) {
                    Mail::to($admins)->send(new ContactMail($request));
                }
                //end
        
                //for user
                if ($request->email) {
                    Mail::to($request->email)->send(new IndianTourismMail($request));
                }
            }else{
                $query->delete();
            }
        }   
        return redirect()->back()->with('message', 'FORM SUBMITTED SUCCESSFULLY');
    }

    public function contact_agency(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|regex:/^[a-zA-Z\s]+$/|max:255',
            'email' => 'required|email',
            'message' => 'nullable|regex:/^[a-zA-Z\s]+$/',
        ]);
        if ($request->faxonly) {
            return redirect()->back()->withSuccess('Your form has been submitted');
        }
        // dd($request);
        $query = new ContactAgency();
        $query->location_id = $request->location_id;
        $query->full_name = $request->name;
        $query->email = $request->email;
        $query->phone = $request->phone_number;
        $query->message = $request->message;
        $query->save();
        
        $country_codes = [
            '780','825','587','403','250','604','236','672','778',
            '431','204','506','428','709','867','902','782','807',
            '905','705','647','613','548','519','437','416','365',
            '343','289','249','226','438','450','514','418','367',
            '819','354','579','873','581','306','639'
        ];
        
        $phone = $request->phone_number;
        
        // Ensure phone is at least 3 characters long before extracting area code
        if (strlen($phone) >= 3) {
            $phone1 = substr($phone, 0, 3);
        
            if (in_array($phone1, $country_codes)) {

                Mail::to($request->email)->send(new IndianTourismMail($request));
        
        
                //admin emails
                $admin_mails = Location::find($request->location_id);
        
                if ($admin_mails) {
                    $admin = explode(',', str_replace(" ", "", $admin_mails->email_cc));
                    $all_emails = array_merge([$request->contact_us_email], $admin);
                    Mail::to($all_emails)->send(new MailContactAgency($query));
                }
            }else{
                $query->delete();
            }
        }

        return redirect()->back()->with('message', 'FORM SUBMITTED SUCCESSFULLY');
    }
}
