<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Mail\AdminMail;
use App\Mail\CareerConfirmMail;
use App\Mail\CareerNotifyMail;
use App\Mail\IndianTourismMail;
use App\Models\AboutUs;
use App\Models\AdminMails;
use App\Models\AirlineImage;
use App\Models\AllDestination;
use App\Models\Career;
use App\Models\ContactQuery;
use App\Models\CruiseShipOption;
use App\Models\CruiseVacation;
use App\Models\Disney;
use App\Models\Flight;
use App\Models\FormData;
use App\Models\GroupVacation;
use App\Models\Home;
use App\Models\HomeBanner;
use App\Models\HomeDestinationForYou;
use App\Models\HomeDestinationForYouLocation;
use App\Models\HomeImage;
use App\Models\HomeTestimonials;
use App\Models\Hotel;
use App\Models\IndianTouristDestination;
use App\Models\Location;
use App\Models\Province;
use App\Models\Service;
use App\Models\ServiceOption;
use App\Models\TopCruisePage;
use App\Models\TopCruisePort;
use App\Models\TopCruisePortLocation;
use App\Models\Travel;
use App\Models\TravelBooking;
use App\Models\TravelLocation;
use App\Models\TravelProfessional;
use App\Models\Vacation;
use App\Models\Wedding;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use PHPUnit\TextUI\XmlConfiguration\Group;

class Homecontroller extends Controller
{
    public function index()
    {
        $content = Home::first();
        $banners = HomeBanner::where('status', 1)->get();
        $home_images = HomeImage::orderBy('position')->get();
        $home_airlines = AirlineImage::all();
        $home_testimonials = HomeTestimonials::all();
        $destinations = HomeDestinationForYou::orderBy('position', 'desc')->paginate(4);

        //$locations = HomeDestinationForYouLocation::all();
        $locations = Location::all();
        return view('Frontend.Pages.Home.index', compact('locations', 'banners', 'content', 'home_images', 'home_airlines', 'home_testimonials', 'destinations'));
    }

    public function indian_tourist_destinations()
    {
        $contents = IndianTouristDestination::all();
        return view('Frontend.Pages.IndianTourist.indian-tourist', compact('contents'));
    }

    public function cruise_vacation()
    {
        $cruise_vacation = CruiseVacation::first();
        return view('Frontend.Pages.Cruises.cruise_vacation', compact('cruise_vacation'));
    }

    public function top_cruise_ports()
    {
        $details = TopCruisePort::with('ports')->get();
        $content = TopCruisePage::first();

        return view('Frontend.Pages.Cruises.top_cruise_ports', compact('details', 'content'));
    }

    public function ports(Request $request)
    {
        $id = $request->id;

        $ports = TopCruisePortLocation::where('port_id', $id)->get();
        return response()->json($ports);
    }

    public function cruise_ship_options()
    {
        $cruise_ship_options = CruiseShipOption::first();
        return view('Frontend.Pages.Cruises.cruise_ship_options', compact('cruise_ship_options'));
    }

    public function flights()
    {
        $flights = Flight::first();
        $locations = Location::all();
        return view('Frontend.Pages.Flight.flight', compact('flights', 'locations'));
    }

    public function vacation()
    {
        $vacation = Vacation::first();
        return view('Frontend.Pages.Vacation.vacation', compact('vacation'));
    }
    public function travel()
    {
        $travel = Travel::first();
        $locations = TravelLocation::where('status',1)->get();
        return view('Frontend.Pages.Travel.travel', compact('travel','locations'));
    }
    public function travel_location($slug)
    {
        $places = Location::all();
        $location = TravelLocation::where('url_key', $slug)->first();
        return view('Frontend.Pages.Travel.travel_location', compact('location','places'));
    }
    public function travel_booking()
    {

        $travel_booking = TravelBooking::first();
        return view('Frontend.Pages.TravelBooking.travelbooking', compact('travel_booking'));
    }

    public function disney()
    {
        $disney = Disney::first();
        return view('Frontend.Pages.Disney.disney', compact('disney'));
    }

    public function hotel()
    {
        $hotel = Hotel::first();
        return view('Frontend.Pages.Hotel.hotel', compact('hotel'));
    }

    public function wedding()
    {
        $wedding = Wedding::first();
        return view('Frontend.Pages.Wedding.wedding', compact('wedding'));
    }

    public function group_vacation()
    {
        $group_vacation = GroupVacation::first();
        return view('Frontend.Pages.GroupVacation.group_vacation', compact('group_vacation'));
    }

    public function aboutus()
    {
        $content = AboutUs::first();
        return view('Frontend.Pages.AboutUs.aboutus', compact('content'));
    }

    public function services()
    {
        $content = Service::first();
        return view('Frontend.Pages.Service.service', compact('content'));
    }

    public function map_locations()
    {
        $map_locations = Location::select('lat', 'lng', 'title', 'phone', 'address', 'slug')->get();
        return response()->json($map_locations);
    }

    public function locations()
    {
        $provinces = Province::all();
        $locations = Location::all();
        return view('Frontend.Pages.Locations.location', compact('locations','provinces'));
    }

    public function location_detail($slug)
    {
        $locationdetail = Location::where('slug', $slug)->first();
        return view('Frontend.Pages.Locations.location-detail', compact('locationdetail'));
    }

    public function booking_forms($page_name)
    {


        $page_name = $page_name;
        $locations = Location::all();
        $options=ServiceOption::all();
        $traveller = request()->traveller ? request()->traveller : '';
        $location_details = request()->location ? request()->location : '';
        return view('Frontend.Pages.FormPage.form-page', compact('traveller', 'locations', 'location_details', 'page_name','options'));
    }
    public function cruiseVacationForm()
    {
        $locations = Location::all();
        $options=ServiceOption::all();
        return view('Frontend.Pages.FormPage.cruise-vacation', compact('locations','options'));
    }
    public function weddingBookingForm()
    {
        $locations = Location::all();
        $options=ServiceOption::all();
        return view('Frontend.Pages.FormPage.wedding-booking', compact('locations','options'));
    }
    public function vacationForm()
    {
        $locations = Location::all();
        $options=ServiceOption::all();
        return view('Frontend.Pages.FormPage.vacation', compact('locations','options'));
    }

    public function booking_forms_submit(Request $request)
    {
        if ($request->faxonly) {
            return redirect()->back()->withSuccess('Your form has been submitted');
        }
        $additional_emails = $request->additional_emails;
        $package_id = $request->package_id;


        $form_data = FormData::create($request->all());
    
        $country_codes = [
            '780','825','587','403','250','604','236','672','778',
            '431','204','506','428','709','867','902','782','807',
            '905','705','647','613','548','519','437','416','365',
            '343','289','249','226','438','450','514','418','367',
            '819','354','579','873','581','306','639'
        ];
        
        $phone = $request->phone_number;
        
        // Ensure phone is at least 3 characters long before extracting area code
        if (strlen($phone) >= 3) {
            $phone1 = substr($phone, 0, 3);
        
            if (in_array($phone1, $country_codes)) {
                Mail::to($request->email)->send(new IndianTourismMail($request));
        
                //admin mails
                $location_mail = Location::find($request->location_id);
                if ($additional_emails && $additional_emails != '') {
                    $travellerDetails = TravelProfessional::find($request->additional_emails);
                    if ($travellerDetails) {
                        $all_emails = array_merge([$location_mail->email], [$travellerDetails->email]);
                    } else {
                        $all_emails = [$location_mail->email];
                    }
                } else {
                    $all_emails = [$location_mail->email];
                }
        
                $admin = explode(',', str_replace(" ", "", $location_mail->email_cc));
                $all_emails = array_merge($all_emails, $admin);
        
                if ($request->location_details) {
                    $location_mail_1 = Location::find($request->location_details);
                    $all_emails = array_merge($all_emails, [$location_mail_1->email]);
                }
        
                if ($package_id) {
                    $package = HomeDestinationForYou::find($package_id);
                }
        
                Mail::to($all_emails)->send(new AdminMail($request));
            }
        }
        return redirect()->back()->with('message', 'FORM SUBMITTED SUCCESSFULLY, WE WILL GET BACK TO YOU SOON');
    }

    public function booking_pacakage_forms($id)
    {
        $content = HomeDestinationForYou::find($id);

        return view('Frontend.Pages.HomePagePackage.package', compact('content'));
    }

    public function booking_package_forms_page()
    {
        $locations = Location::all();
        $package_id = request()->package_id;
        return view('Frontend.Pages.FormPage.form-page', compact('package_id', 'locations'));

        // return view('Frontend.Pages.HomePagePackage.package-form');
    }

    public function booking_package_forms_submit()
    {
    }

    public function career_page()
    {
        $locations = Location::all();
        return view('Frontend.Pages.CareerPage.CareerPage', compact('locations'));
    }

    public function career_form(Request $request)
    {
        $this->validate($request, [
            'first_name' => 'required|regex:/^[a-zA-Z\s]+$/|max:255',
            'last_name' => 'required|regex:/^[a-zA-Z\s]+$/',
            'phone_number' => 'required',
            'email' => 'required|email',
            'status_in_canada' => 'nullable|regex:/^[a-zA-Z\s]+$/',
            'position' => 'nullable|regex:/^[a-zA-Z\s]+$/',
            'message' => 'nullable|regex:/^[a-zA-Z\s]+$/',
        ]);
        if ($request->faxonly) {
            return redirect()->back()
                ->withSuccess('Your form has been submitted');
        }
        $career = Career::create($request->all());
        $file = $request->file('file')->store('resume_file', 'public');
        $career->file = $file;
        $career->save();

        //send confirmation email
        Mail::to($request->email)->send(new CareerConfirmMail($career));

        //admin mails
        $location_mail = Location::find($request->location_id);

        if ($location_mail) {
            $admin = explode(',', str_replace(" ", "", $location_mail->email_cc));
            $all_emails = array_merge($admin, [$location_mail->email]);
            Mail::to($all_emails)->send(new CareerNotifyMail($career));
        }


        return redirect()->back()->with('message', 'FORM SUBMITTED SUCCESSFULLY, WE WILL GET BACK TO YOU SOON');
    }
    public function allpackages()
    {
        $content = AllDestination::first();
        $destinations = HomeDestinationForYou::all();
        return view('Frontend.Pages.allpackages', compact('content', 'destinations'));
    }
}
