<?php

namespace App\Http\Controllers;

use App\Models\ServiceOption;
use Illuminate\Http\Request;

class ServiceOptionController extends Controller
{
    public function index()
    {
        $options = ServiceOption::paginate(10);
        return view('Admin.serviceOptions.list', compact('options'));
    }
    public function create()
    {
        return view('Admin.serviceOptions.create');
    }
    public function store(Request $request)
    {
        $request->validate([
            'service_type' => 'required',
            'option' => 'required',
        ]);
        ServiceOption::create($request->all());
        return redirect()->route('admin.service-options')->with('success', 'Option added successfully');
    }
    public function edit($id)
    {
        $option = ServiceOption::find($id);
        return view('Admin.serviceOptions.edit', compact('option'));
    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'service_type' => 'required',
            'option' => 'required',
        ]);
        $option = ServiceOption::find($id);
        $option->update($request->all());
        return redirect()->route('admin.service-options')->with('success', 'Option added successfully');
    }

    public function destroy($id)
    {
        ServiceOption::destroy($id);
        return back()->with('success', 'Option deleted successfully');
    }
}
