<?php

namespace App\Mail;

use App\Models\Location;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AdminMail extends Mailable
{
    public $query, $destination_name, $page_name,$location;
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($query, $destination_name = null, $page_name = null)
    {
        $this->query = $query;
        $this->destination_name = $destination_name;
        $this->page_name = $page_name;
        $this->location = Location::find($this->query->location_id);
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function build()
    {

        return $this->subject('Gill International - Admin Mail')
            ->view('Frontend.Mail.AdminMail');
    }
}
