<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormData extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_id',
        'location_id',
        'page_name',
        'first_name',
        'last_name',
        'email',
        'phone_number',
        'service_type',
        'travelling_from',
        'travelling_to',
        'from_date',
        'to_date',
        'no_of_adults',
        'no_of_kids',
        'no_of_infants',
        'comments',
        'service',
        'wedding_service'
    ];

    public function location(){
        return $this->belongsTo(Location::class);
    }

}
