<?php

namespace App\Models;

use App\Http\Controllers\Admin\Career\CareerQuery;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Location extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'address',
        'phone',
        'email',
        'email_cc',
        'map_link',
        'position',
        'lat',
        'lng',
        'timings',
        'status',
        'province_id',
        'meta_title',
        'meta_description',
        'meta_keywords',
    ];

    public function location()
    {
        return $this->hasMany(TravelProfessional::class, 'location_id');
    }

    public function inquires()
    {

        return $this->hasMany(FormData::class, 'location_id');
    }

    public function careers()
    {

        return $this->hasMany(Career::class, 'location_id');
    }

    public function contact_agency()
    {

        return $this->hasMany(ContactAgency::class, 'location_id');
    }
    public function flights()
    {

        return $this->hasMany(FligtForm::class, 'location_id');
    }
}
