<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('top_cruise_port_locations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('port_id')->nullable()->constrained('top_cruise_ports')->onDelete('cascade');
            $table->string('port_location_name');
            $table->text('description');
            $table->string('image');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('top_cruise_port_locations');
    }
};
