<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('locations', function (Blueprint $table) {
            $table->text('email_cc')->nullable()->after('email');
        });

        Schema::table('admin_mails', function (Blueprint $table) {
            $table->dropColumn('admin_mails');
            $table->text('subscription')->nullable()->after('id');
            $table->text('career')->nullable()->after('id');
            $table->text('contact_us')->nullable()->after('id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('locations', function (Blueprint $table) {
            $table->dropColumn('email_cc');
        });

        Schema::table('admin_mails', function (Blueprint $table) {
            $table->text('admin_mails');
            $table->dropColumn('subscription');
            $table->dropColumn('career');
            $table->dropColumn('contact_us');
        });
    }
};
