@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add About Us Page Content</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data"
                action=@if ($content) {{ route('admin.about-us.update', $content->id) }}  @else {{ route('admin.about-us.store') }} @endif>
                @if ($content)
                    @method('PATCH')
                @endif
                @csrf
                {{-- Banner title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Title|Banner
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="title" name="title" placeholder="Title"
                                    value="{{ $content ? $content->title : '' }}">
                                @error('title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Banner">Banner<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="banner" name="banner"
                                    placeholder="Banner" accept="phone_number/*">

                                @error('banner')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="phone_number-section">
                                        <div class="phone_number"> <img src="{{ asset("storage/$content->banner") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- Header --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Section 2
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="description">Description<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="description" name="description"
                                    placeholder="description" value="{{ $content ? $content->description : '' }}">
                                @error('Description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Header Image">Image<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="image"
                                    placeholder="Header Image 1" accept="image/*">
                                @error('image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->image") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Why choose us
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse show" aria-labelledby="headingThree">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Map book">Why choose us<span style="color: red">*</span></label>
                                <textarea class="form-control" id="description" name="why_choose_us" placeholder="Why choose us">{{ $content ? $content->why_choose_us : '' }}</textarea>
                                @error('why_choose_us')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Why choose us content 1">Why choose us title 1<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="why_choose_us_1_title"
                                    name="why_choose_us_1_title" placeholder="Why choose us content 1"
                                    value="{{ $content ? $content->why_choose_us_1_title : '' }}">
                                @error('why_choose_us_1_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Why choose us content 1">Why choose us description 1<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="description" name="why_choose_us_1_description"
                                    placeholder="Why choose us description"
                                    value="{{ $content ? $content->why_choose_us_1_description : '' }}">
                                @error('why_choose_us_1_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Why choose us icon 1">Why choose us icon 1<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="why_choose_us_1_icon"
                                    placeholder="Header Image 1" accept="image/*">
                                @error('why_choose_us_1_icon')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->why_choose_us_1_icon") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            
                            <div class="form-group">
                                <label for="Why choose us content ">Why choose us title 2<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="why_choose_us_2_title"
                                    name="why_choose_us_2_title" placeholder="Why choose us content 2"
                                    value="{{ $content ? $content->why_choose_us_2_title : '' }}">
                                @error('why_choose_us_2_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Why choose us content 1">Why choose us description 2<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="description" name="why_choose_us_2_description"
                                    placeholder="Why choose us description"
                                    value="{{ $content ? $content->why_choose_us_2_description : '' }}">
                                @error('why_choose_us_2_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Why choose us icon 2">Why choose us icon 2<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="why_choose_us_2_icon"
                                    placeholder="Why choose us icon 2" accept="image/*">
                                @error('why_choose_us_2_icon')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->why_choose_us_2_icon") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            
                            <div class="form-group">
                                <label for="Why choose us content 1">Why choose us title 3<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="why_choose_us_3_title"
                                    name="why_choose_us_3_title" placeholder="Why choose us content 3"
                                    value="{{ $content ? $content->why_choose_us_3_title : '' }}">
                                @error('why_choose_us_3_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Why choose us content 3">Why choose us description 3<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="description" name="why_choose_us_3_description"
                                    placeholder="Why choose us description"
                                    value="{{ $content ? $content->why_choose_us_3_description : '' }}">
                                @error('why_choose_us_3_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Why choose us icon 3">Why choose us icon 3<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="why_choose_us_3_icon"
                                    placeholder="Why choose us icon 3" accept="image/*">
                                @error('why_choose_us_3_icon')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->why_choose_us_3_icon") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                           Counter
                        </button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse show" aria-labelledby="headingFour">
                        <div class="accordion-body">
                            
                            <div class="form-group">
                                <label for="Counter 1 title">Counter 1 title<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="counter_1_title"
                                    name="counter_1_title" placeholder="Counter 1 title"
                                    value="{{ $content ? $content->counter_1_title : '' }}">
                                @error('counter_1_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Counter 1 count">Counter 1 count<span
                                        style="color: red">*</span></label>
                                <input type="number" class="form-control" id="counter_1_count" name="counter_1_count"
                                    placeholder="Counter 1 count"
                                    value="{{ $content ? $content->counter_1_count : '' }}">
                                @error('counter_1_count')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Counter 1 icon">Counter 1 icon<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="counter_1_icon"
                                    placeholder="Header Image 1" accept="image/*">
                                @error('counter_1_icon')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->counter_1_icon") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                       
                        <div class="accordion-body">
                            
                            <div class="form-group">
                                <label for="Counter 1 title">Counter 2 title<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="counter_2_title"
                                    name="counter_2_title" placeholder="Counter 2 title"
                                    value="{{ $content ? $content->counter_2_title : '' }}">
                                @error('counter_2_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Counter 2 count">Counter 2 count<span
                                        style="color: red">*</span></label>
                                <input type="number" class="form-control" id="counter_2_count" name="counter_2_count"
                                    placeholder="Counter 2 count"
                                    value="{{ $content ? $content->counter_2_count : '' }}">
                                @error('counter_2_count')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Counter 1 icon">Counter 2 icon<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="counter_2_icon"
                                    placeholder="Counter 2 icon" accept="image/*">
                                @error('counter_2_icon')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->counter_2_icon") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            
                            <div class="form-group">
                                <label for="Counter 3 title">Counter 3 title<span
                                        style="color: red">*</span></label>
                                <input type="text" class="form-control" id="counter_3_title"
                                    name="counter_3_title" placeholder="Counter 3 title"
                                    value="{{ $content ? $content->counter_3_title : '' }}">
                                @error('counter_3_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Counter 3 count">Counter 3 count<span
                                        style="color: red">*</span></label>
                                <input type="number" class="form-control" id="counter_3_count" name="counter_3_count"
                                    placeholder="Counter 3 count"
                                    value="{{ $content ? $content->counter_3_count : '' }}">
                                @error('counter_3_count')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Counter 3 icon">Counter 3 icon<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="counter_3_icon"
                                    placeholder="Counter 3 icon" accept="image/*">
                                @error('counter_3_icon')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->counter_3_icon") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        
                    </div>
                </div>


                {{-- Meta details  --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSeven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            Meta details
                        </button>
                    </h2>
                    <div id="collapseSeven" class="accordion-collapse collapse show" aria-labelledby="headingSeven">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Meta title">Meta title<span style="color: red">*</span></label>
                                <textarea class="form-control" rows="8" id="meta_title" name="meta_title" placeholder="Meta Title">{{ $content ? $content->meta_title : '' }}</textarea>
                                @error('meta_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Meta Description">Meta Description<span style="color: red">*</span></label>
                                <textarea class="form-control" rows="8" id="meta_description" name="meta_description"
                                    placeholder="Meta Description">{{ $content ? $content->meta_description : '' }}</textarea>
                                @error('meta_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <div class="form-group">
                                    <label for="Meta Keywords">Meta Keywords<span style="color: red">*</span></label>
                                    <textarea class="form-control" rows="8" id="meta_keywords" name="meta_keywords" placeholder="Meta Keywords">{{ $content ? $content->meta_keywords : '' }}</textarea>
                                    @error('meta_keywords')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
