@extends('Admin.layout.master')

@section('page-contents')
    <div>
        <div class="row">
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">Contact Agency Inquiry Details </h1>
            </div>
            <div class="col-lg-12 mx-auto">

                <div class="view-detail">
                    <div class="form-group">
                        <label for="Location">Location Name</label>
                        <input type="text" class="form-control" value="{{ $inquiry->location->title }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Full Name">Full Name</label>
                        <input type="text" class="form-control" value="{{ $inquiry->full_name }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Email</label>
                        <input type="text" class="form-control" value="{{ $inquiry->email }}" readonly>
                    </div>

                    <div class="form-group">
                        <label for="Phone Number">Phone Number</label>
                        <input type="text" class="form-control" value="{{ $inquiry->phone }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Message">Message</label>
                        <textarea class="form-control" rows="8" readonly>{{ $inquiry->message }}</textarea>
                    </div>
                </div>

                <a href="{{ route('admin.contact-agency.index') }}">
                    <button class="btn btn-sm btn-info">
                        <i class="fa fa-arrow-left"></i>
                    </button>
                </a>
            </div>
        </div>
    </div>
@endsection
