@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Destinations</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" action="{{ route('admin.destination.store') }}" enctype="multipart/form-data">
                @method('POST')
                @csrf
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Title|Banner
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="title" name="title"
                                    placeholder="Title" required>
                                @error('title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Slug">Slug<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="slug" name="slug" placeholder="Slug"
                                    value="{{ old('slug') }}" readonly>
                            </div>
                            <div class="form-group">
                                <label for="image">Banner<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="banner" name="banner"
                                    placeholder="Banner" accept="image/*">
                                @error('banner')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Destination Image">Destination Image<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="destination_image" name="destination_image"
                                    placeholder="Destination Image" accept="image/*">
                                @error('destination_image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>


                            <div class="form-group">
                                <label for="description">Description<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="description" name="description"
                                    placeholder="Description">
                                @error('description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Destination Guide
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div id="guide_list">

                            </div>
                        </div>
                        <button type="button" class="btn btn-danger btn-sm" id="add_destination_guide">+ Add
                           </button>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Experiencing the Destination
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse show" aria-labelledby="headingThree">
                        <div class="accordion-body">
                            <div id="experience_list">

                            </div>
                        </div>
                        <button type="button" class="btn btn-danger btn-sm" id="add_destination_experience">+ Add
                            </button>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function() {
            var html = getHtml();
            $('#guide_list').html('');
            $('#guide_list').append(html);

            tinymce.init({
                selector: '.editor-description',
                plugins: 'code',
                valid_elements: '*[*]',
            });
        })


        function getHtml() {
            return `
                <div>
                                    <div class="form-group">
                                        <label for="Title">Title<span style="color: red">*</span></label>
                                        <input type="text" class="form-control slug" id="title" name="guide_title[]"
                                            placeholder="Title">
                                        @error('title')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="image">Image<span style="color: red">*</span></label>
                                        <input type="file" class="form-control" id="image" name="guide_image[]"
                                            placeholder="Image" accept="image/*">
                                        @error('image')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Description<span style="color: red">*</span></label>
                                        <input type="text" class="form-control editor-description"  name="guide_description[]"
                                            placeholder="Description">
                                        @error('description')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Links">Links<span style="color: red">*</span></label>
                                        <input type="text" class="form-control" id="link" name="guide_link[]"
                                            placeholder="link">
                                        @error('link')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Position">Position<span style="color: red">*</span></label>
                                        <input type="number" class="form-control" id="link" name="guide_position[]"
                                            placeholder="position">
                                        @error('position')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

        `;
        }
    </script>

    <script>
        $(document).on("click", "#add_destination_guide", function(event) {
            // alert("hi");
            var html = getHtml();
            $('#guide_list').append(html);
            tinymce.init({
                selector: '.editor-description',
                plugins: 'code',
                valid_elements: '*[*]',
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            var html = getHtml1();
            $('#experience_list').html('');
            $('#experience_list').append(html);

            tinymce.init({
                selector: '.editor-description',
                plugins: 'code',
                valid_elements: '*[*]',
            });
        })


        function getHtml1() {
            return `
            <div>
                                <div class="form-group">
                                    <label for="Title">Title<span style="color: red">*</span></label>
                                    <input type="text" class="form-control slug" id="title" name="experience_title[]"
                                        placeholder="Title">
                                    @error('title')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="image">Image<span style="color: red">*</span></label>
                                    <input type="file" class="form-control" id="image" name="experience_image[]"
                                        placeholder="Image" accept="image/*">
                                    @error('image')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="description">Description<span style="color: red">*</span></label>
                                    
                                    <textarea class="form-control editor-description" name="experience_description[]"
                                        placeholder="Description"></textarea>
                                    @error('description')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="Links">Links<span style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="link" name="experience_link[]"
                                        placeholder="link">
                                    @error('link')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="Position">Position<span style="color: red">*</span></label>
                                    <input type="number" class="form-control" id="link" name="experience_position[]"
                                        placeholder="position">
                                    @error('position')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

    `;
        }
    </script>
    <script>
        $(document).on("click", "#add_destination_experience", function(event) {

            var html = getHtml1();
            $('#experience_list').append(html);
            tinymce.init({
                selector: '.editor-description',
                plugins: 'code',
                valid_elements: '*[*]',
            });
        });
    </script>

    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
@endpush
