@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Destinations</h1>
        {{-- <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                            class="fas fa-download fa-sm text-white-50"></i> Generate Report</a> --}}
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" action="{{ route('admin.destination.update', $destination->id) }}"
                enctype="multipart/form-data">
                @method('PATCH')
                @csrf
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Title|Banner
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="title" name="title"
                                    value="{{ $destination->title }}">
                                @error('title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Slug">Slug<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="slug" name="slug"
                                    value="{{ $destination->slug }}" value="{{ old('slug') }}" readonly>
                            </div>
                            <div class="form-group">
                                <label for="image">Banner<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="banner" name="banner"
                                    placeholder="Banner" accept="image/*">
                                @error('banner')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <div class="image-section">
                                    <div class="image"> <img src="{{ asset("storage/$destination->banner") }}"
                                            height="50px">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="Destination Image">Destination Image<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="destination_image" name="destination_image"
                                    placeholder="Destination Image" accept="image/*">
                                @error('destination_image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <div class="image-section">
                                    <div class="image"> <img src="{{ asset("storage/$destination->destination_image") }}"
                                            height="50px">
                                    </div>
                                </div>
                            </div>


                            <div class="form-group">
                                <label for="description">Description<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="description" name="description"
                                    value="{{ $destination->destination_description }}">
                                @error('description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Destination Guide
                        </button>
                    </h2>

                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        @foreach ($destination_contents as $destination_content)
                            <div class="accordion-body">
                                <div>
                                    <div class="form-group">
                                        <input type="hidden" name="guide_id[]" value="{{ $destination_content->id }}">
                                        <input type="hidden" name="guide_destination_id[]"
                                            value="{{ $destination_content->destination_id }}">
                                        <label for="Title">Title<span style="color: red">*</span></label>
                                        <input type="text" class="form-control slug" id="title"
                                            name="guide_title[]" value="{{ $destination_content->title }}">
                                        @error('title')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="image">Image<span style="color: red">*</span></label>
                                        <input type="file" class="form-control" id="image" name="guide_image[]"
                                            placeholder="Image" accept="image/*">
                                        @error('image')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <div class="image-section">
                                            <div class="image"> <img
                                                    src="{{ asset("storage/$destination_content->image") }}"
                                                    height="50px">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Description<span style="color: red">*</span></label>
                                        <input type="text" class="form-control" id="description"
                                            name="guide_description[]" value="{{ $destination_content->description }}">
                                        @error('description')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Links">Links<span style="color: red">*</span></label>
                                        <input type="text" class="form-control" id="link" name="guide_link[]"
                                            value="{{ $destination_content->links }}">
                                        @error('link')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Position">Position<span style="color: red">*</span></label>
                                        <input type="number" class="form-control" id="link"
                                            name="guide_position[]" value="{{ $destination_content->position }}">
                                        @error('position')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <div id="guide_list"></div>
                        <button type="button" class="btn btn-danger btn-sm" id="add_destination_guide">+ Add
                            Destination</button>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Experiencing the Destination
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse show" aria-labelledby="headingThree">
                        @foreach ($experience_contents as $experience_content)
                            <div class="accordion-body">
                                <div id="experience_list">
                                    <div class="form-group">
                                        <input type="hidden" name="experience_id[]"
                                            value="{{ $experience_content->id }}">
                                        <input type="hidden" name="experience_destination_id[]"
                                            value="{{ $experience_content->destination_id }}">
                                        <label for="Title">Title<span style="color: red">*</span></label>
                                        <input type="text" class="form-control slug" id="title"
                                            name="experience_title[]" value="{{ $experience_content->title }}">
                                        @error('title')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="image">Image<span style="color: red">*</span></label>
                                        <input type="file" class="form-control" id="image"
                                            name="experience_image[]" placeholder="Image" accept="image/*">
                                        @error('image')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <div class="image-section">
                                            <div class="image"> <img
                                                    src="{{ asset("storage/$experience_content->image") }}"
                                                    height="50px">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Description<span style="color: red">*</span></label>
                                        <input type="text" class="form-control" id="description"
                                            name="experience_description[]"
                                            value="{{ $experience_content->description }}">
                                        @error('description')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Links">Links<span style="color: red">*</span></label>
                                        <input type="text" class="form-control" id="link"
                                            name="experience_link[]" value="{{ $experience_content->link }}">
                                        @error('link')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Position">Position<span style="color: red">*</span></label>
                                        <input type="number" class="form-control" id="link"
                                            name="experience_position[]" value="{{ $experience_content->position }}">
                                        @error('position')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        <div id="experience_list"></div>
                        <button type="button" class="btn btn-danger btn-sm" id="add_destination_experience">+ Add
                            Destination</button>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
    <script>
        $(document).on("click", "#add_destination_guide", function(event) {
            // alert("hi");
            var html = getHtml();
            $('#guide_list').append(html);
            tinymce.init({
                selector: '.editor-description',
                plugins: 'code',
                valid_elements: '*[*]',
            });
        });

        function getHtml() {
            return `
                <div>
                                    <div class="form-group">
                                        <label for="Title">Title<span style="color: red">*</span></label>
                                        <input type="text" class="form-control slug" id="title" name="guide_title[]"
                                            placeholder="Title">
                                        @error('title')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="image">Image<span style="color: red">*</span></label>
                                        <input type="file" class="form-control" id="image" name="guide_image[]"
                                            placeholder="Image" accept="image/*">
                                        @error('image')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Description<span style="color: red">*</span></label>
                                        <input type="text" class="form-control editor-description"  name="guide_description[]"
                                            placeholder="Description">
                                        @error('description')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Links">Links<span style="color: red">*</span></label>
                                        <input type="text" class="form-control" id="link" name="guide_link[]"
                                            placeholder="link">
                                        @error('link')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Position">Position<span style="color: red">*</span></label>
                                        <input type="number" class="form-control" id="link" name="guide_position[]"
                                            placeholder="position">
                                        @error('position')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

        `;
        }
    </script>
    <script>
        $(document).on("click", "#add_destination_experience", function(event) {
            // alert("hi");
            var html = getHtml1();
            $('#experience_list').append(html);
            tinymce.init({
                selector: '.editor-description',
                plugins: 'code',
                valid_elements: '*[*]',
            });
        });

        function getHtml1() {
            return `
            <div>
                                <div class="form-group">
                                    <label for="Title">Title<span style="color: red">*</span></label>
                                    <input type="text" class="form-control slug" id="title" name="experience_title[]"
                                        placeholder="Title">
                                    @error('title')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="image">Image<span style="color: red">*</span></label>
                                    <input type="file" class="form-control" id="image" name="experience_image[]"
                                        placeholder="Image" accept="image/*">
                                    @error('image')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="description">Description<span style="color: red">*</span></label>
                                    
                                    <textarea class="form-control editor-description" name="experience_description[]"
                                        placeholder="Description"></textarea>
                                    @error('description')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="Links">Links<span style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="link" name="experience_link[]"
                                        placeholder="link">
                                    @error('link')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="Position">Position<span style="color: red">*</span></label>
                                    <input type="number" class="form-control" id="link" name="experience_position[]"
                                        placeholder="position">
                                    @error('position')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

    `;
        }
    </script>
    <script>
        $(document).on("click", ".experience_item_remove", function(event) {
            $(this).parent().closest(".experience_item").remove();
        });
    </script>
@endpush
