@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Home Page Destinations For You Content</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data" action={{ route('admin.home-destination-for-you.store') }}>

                @csrf
                {{-- image title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Location
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="LocationName">Location<span style="color: red">*</span></label>
                                <select name="location_id" class="form-control" required>
                                    <option value="">Select</option>
                                    @foreach ($locations as $location)
                                        <option {{ old('location_id') == $location->id ? 'selected' : '' }}
                                            value="{{ $location->id }}" id="{{ $location->id }}">
                                            {{ $location->location_name }} </option>
                                    @endforeach
                                </select>
                                @error('location_id')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Package Name">Package Name<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="package_name" name="package_name"
                                    placeholder="Package Name" value="{{ old('package_name') }}" required>
                                @error('package_name')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Package Details">Package Details<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="package_details" name="package_details"
                                    placeholder="Package Details">
                                @error('package_details')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Price">Price<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="price" name="price" placeholder="Price"
                                    required value="{{old('price')}}">
                                @error('price')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Price Note">Price Note<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="price_note" name="price_note"
                                    placeholder="Price Note" value="{{old('price_note')}}" required>
                                @error('price_note')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Image">Image<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="image" placeholder="Image"
                                    required>
                                @error('image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Image">Image 2<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="image1" placeholder="Image"
                                    accept="image/*" required>

                                @error('image1')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Image">Image 3</label>
                                <input type="file" class="form-control" id="image" name="image2" placeholder="Image"
                                    accept="image/*">

                                @error('image2')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="PDF">PDF<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="pdf" name="pdf" placeholder="PDF"
                                    required>
                                @error('image2')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="PDF">Position</label>
                                <input type="number" class="form-control" value="{{old('position')}}" name="position" placeholder="Position" required>
                                @error('position')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Status">Status<span style="color: red">*</span></label>
                                <select name="status" class="form-control" required>
                                    <option value="1" selected id="active">  Active </option> 
                                    <option value="0" id="inactive"> Inactive </option>
                                </select>
                                @error('status')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
@endpush
