@extends('Admin.layout.master')

@section('page-contents')
    <div class="table-detail">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Full Name</th>
                    <th scope="col">Email</th>
                    <th scope="col">Phone</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($queries as $index => $query)
                    <tr>
                        <th scope="row">{{ $queries->firstItem() + $index }}</th>
                        <td>{{ $query->first_name }} {{ $query->last_name }}</td>
                        <td>{{ $query->email }}</td>
                        <td>{{ $query->phone }}</td>
                        <td>
                            <a href="{{ route('admin.indian-tourism-query.show', $query->id) }}">
                                <i class="fas fa-eye"></i>
                            </a>
                            @role('Super Admin')
                                <a class="deleteRecord" data-id="form-submit-{{ $query->id }}"
                                    data-route="{{ route('admin.indian-tourism-query.destroy', $query->id) }}">
                                    <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                </a>
                                <form method="POST" id="form-submit-{{ $query->id }}"
                                    action="{{ route('admin.indian-tourism-query.destroy', $query->id) }}" hidden>
                                    @method('DELETE')
                                    @csrf
                                    <button type="submit"><i class="fas fa-trash"></i></button>
                                </form>
                            @endrole
                        </td>
                    </tr>
                @endforeach
                @if (session()->has('message'))
                    <div class="alert alert-success">
                        {{ session()->get('message') }}
                    </div>
                @endif
            </tbody>
        </table>
        {{ $queries->links('pagination::bootstrap-4') }}
    </div>
@endsection

@push('scripts')
    <script>
        $('.deleteRecord').on('click', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this?')) {
                $('#' + id + '').submit();
            }
        })
    </script>
@endpush
