@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Indian Tourism Page Content</h1>
        {{-- <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                            class="fas fa-download fa-sm text-white-50"></i> Generate Report</a> --}}
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" action="{{ route('admin.indian-tourism.update', $content->id) }}"
                enctype="multipart/form-data">
                @method('PATCH')
                @csrf
                <div class="form-group">
                    <label for="Destination Name">Destination Name<span style="color: red">*</span></label>
                    <input type="text" class="form-control slug" id="destination_name" name="destination_name"
                        value="{{ $content->destination_name }}">
                    @error('destination_name')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="Slug">Slug<span style="color: red">*</span></label>
                    <input type="text" class="form-control" id="slug" name="slug" placeholder="Slug"
                        value="{{ $content->slug }}" readonly>
                </div>
                <div class="form-group">
                    <label for="Image">Image 1<span style="color: red">*</span></label>
                    <input type="file" class="form-control" id="image" name="image" placeholder="Image"
                        accept="image/*">

                    @error('image')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>

                @if ($content)
                    <div class="form-group">
                        <div class="image-section">
                            <div class="image"> <img src="{{ asset("storage/$content->image") }}" height="50px">
                            </div>
                        </div>
                    </div>
                @endif
                <div class="form-group">
                    <label for="Image">Image 2<span style="color: red">*</span></label>
                    <input type="file" class="form-control" id="image" name="image1" placeholder="Image"
                        accept="image/*">

                    @error('image2')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>

                @if ($content)
                    <div class="form-group">
                        <div class="image-section">
                            <div class="image"> <img src="{{ asset("storage/$content->image1") }}" height="50px">
                            </div>
                        </div>
                    </div>
                @endif
                <div class="form-group">
                    <label for="Image">Image 3<span style="color: red">*</span></label>
                    <input type="file" class="form-control" id="image" name="image2" placeholder="Image"
                        accept="image/*">

                    @error('image3')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>

                @if ($content)
                    <div class="form-group">
                        <div class="image-section">
                            <div class="image"> <img src="{{ asset("storage/$content->image2") }}" height="50px">
                            </div>
                        </div>
                    </div>
                @endif

                <div class="form-group">
                    <label for="Pdf">Pdf<span style="color: red">*</span></label>
                    <input type="file" class="form-control" id="pdf" name="pdf" placeholder="Pdf">

                    @error('pdf')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>

                @if ($content)
                    <div class="form-group">
                        <div class="image-section">
                            <div class="image"> <embed src="{{ asset("storage/$content->pdf") }}" width="800px"
                                    height="200px" /></div>
                        </div>
                    </div>
                @endif


                <div class="form-group">
                    <label for="description">Description<span style="color: red">*</span></label>
                    <input type="text" class="form-control" id="description" name="description"
                        value="{{ $content->description }}">
                    @error('description')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="Position">Position</label>
                    <input type="number" class="form-control" id="position" name="position"
                        value="{{ $content->position }}">
                    @error('position')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="Status">Status<span style="color: red">*</span></label>
                    <select name="status" class="form-control">
                        <option value="{{ $content->status }}">{{ $content->status ? 'Active' : 'Inactive' }}</option>
                        <option value="0" id="inactive">
                            Inactive </option>
                        <option value="1" id="active">
                            Active </option>
                    </select>
                    @error('status')
                        <span class="error">{{ $message }}</span>
                    @enderror
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
@endpush
