@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Locations</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data" action={{ route('admin.location.update', $location->id) }}>
                @method('PUT')
                @csrf
                {{-- image title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Location Details
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="province">Province<span style="color: red">*</span></label>
                                <select name="province_id" class="form-control">
                                    <option value="">Select Province</option>
                                    @foreach ($provinces as $province)
                                        <option value="{{ $province->id }}" @if ($location->province_id == $province->id) selected @endif>{{ $province->name }}</option>
                                    @endforeach
                                </select>
                                @error('status')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Title">Title<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="title" name="title"
                                    value="{{ $location->title }}">
                                @error('title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Slug">Slug<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="slug" name="slug"
                                    value="{{ $location->slug }}">
                                @error('slug')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Address">Address<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="address" name="address"
                                    value="{{ $location->address }}">
                                @error('address')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Phone">Phone<span style="color: red">*</span></label>
                                <input type="tel" class="form-control" id="phone" name="phone"
                                    value="{{ $location->phone }}">
                                @error('phone')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Email">Email<span style="color: red">*</span></label>
                                <input type="email" class="form-control" id="email" name="email"
                                    value="{{ $location->email }}">
                                @error('email')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Email">CC<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="email_cc" name="email_cc"
                                    placeholder="Email" value="{{ $location->email_cc }}">
                                @error('email_cc')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Latitude">Latitude<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="lat" name="lat"
                                    value="{{ $location->lat }}">
                                @error('lat')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Logitude">Logitude<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="lng" name="lng"
                                    value="{{ $location->lng }}">
                                @error('lng')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Map Link">Map Link<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="map_link" name="map_link"
                                    value="{{ $location->map_link }}">
                                @error('map_link')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Position">Position<span style="color: red">*</span></label>
                                <input type="number" class="form-control" id="position" name="position"
                                    value="{{ $location->position }}">
                                @error('position')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="Timings">Timings<span style="color: red">*</span></label>
                                <textarea class="form-control" rows="8" id="timings" name="timings" placeholder="Timings">{{ $location->timings }}</textarea>
                                @error('timings')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        {{-- Meta details  --}}
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingSeven">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                    Meta details
                                </button>
                            </h2>
                            <div id="collapseSeven" class="accordion-collapse collapse show"
                                aria-labelledby="headingSeven">
                                <div class="accordion-body">
                                    <div class="form-group">
                                        <label for="Meta title">Meta title<span style="color: red">*</span></label>
                                        <textarea class="form-control" rows="4" id="meta_title" name="meta_title" placeholder="Meta Title">{{ $location->meta_title }}</textarea>
                                        @error('meta_title')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Meta Description">Meta Description<span
                                                style="color: red">*</span></label>
                                        <textarea class="form-control" rows="8" id="meta_description" name="meta_description"
                                            placeholder="Meta Description">{{ $location->meta_description }}</textarea>
                                        @error('meta_description')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label for="Meta Keywords">Meta Keywords<span
                                                    style="color: red">*</span></label>
                                            <textarea class="form-control" rows="8" id="meta_keywords" name="meta_keywords" placeholder="Meta Keywords">{{ $location->meta_keywords }}</textarea>
                                            @error('meta_keywords')
                                                <span class="error">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
@endpush
