@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Travel Professionals</h1>
    </div>
    <div>
        <a class="btn btn-danger btn-sm" href="{{ route('admin.travel-professionals.create') }}">
            Add
        </a>
    </div>
    <form action="" method="GET" style="padding: 0px">
        <div class="row">
            <div class="col-lg-2">
                <input type="text" class="form-control" name="search" placeholder="Search">
            </div>
            <div class="col-lg-3">
                <select name="location_id" class="form-control" id="location_id" class="c-select">
                    <option value="">Select Location</option>
                    @foreach ($locations as $location)
                        <option value="{{ $location->id }}">
                            {{ $location->title }} </option>
                    @endforeach

                </select>
            </div>
            <div class="col-lg-2">
                <input type="submit" class="btnSearch" value="Search">
            </div>
        </div>
    </form>
    <div class="table-detail">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Name</th>
                    <th scope="col">Email</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($details as $index => $detail)
                    <tr>
                        <th scope="row">{{ $details->firstItem() + $index }}</th>
                        <td>{{ $detail->name }}</td>
                        <td>{{ $detail->email }}</td>
                        <td>
                            <a href="{{ route('admin.travel-professionals.edit', $detail->id) }}">
                                <i class="fas fa-edit"></i>
                            </a>
                            @role('Super Admin')
                                <a class="deleteRecord" data-id="form-submit-{{ $detail->id }}"
                                    data-route="{{ route('admin.travel-professionals.destroy', $detail->id) }}">
                                    <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                </a>
                                <form method="POST" id="form-submit-{{ $detail->id }}"
                                    action="{{ route('admin.travel-professionals.destroy', $detail->id) }}" hidden>
                                    @method('DELETE')
                                    @csrf
                                    <button type="submit"><i class="fas fa-trash"></i></button>
                                </form>
                            @endrole

                        </td>
                    </tr>
                @endforeach
                @if (session()->has('message'))
                    <div class="alert alert-success">
                        {{ session()->get('message') }}
                    </div>
                @endif
            </tbody>
        </table>
        {{ $details->links('pagination::bootstrap-4') }}
    </div>
@endsection

@push('scripts')
    <script>
        $('.deleteRecord').on('click', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this?')) {
                $('#' + id + '').submit();
            }
        })
    </script>
@endpush
