@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Service Options</h1>
    </div>
    <x-session />
    <div>
        <a class="btn btn-danger btn-sm" href="{{ route('admin.service-option.create') }}">
            Add
        </a>
    </div>
    <div class="table-detail">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Title</th>
                    <th scope="col">Type</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($options as $option)
                    <tr>
                        <th scope="row">{{ $loop->iteration }}</th>
                        <td>{{ $option->option }}</td>

                        <td>{{ $option->service_type }}</td>
                        <td>
                            <a href="{{ route('admin.service-option.edit', $option->id) }}">
                                <i class="fas fa-edit"></i>
                            </a>
                            @role('Super Admin')
                                <a onclick="return confirm('are you sure?')" href="{{ route('admin.service-option.delete',$option->id) }}">
                                    <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                </a>
                            @endrole
                        </td>
                    </tr>
                @endforeach
                @if (session()->has('message'))
                    <div class="alert alert-success">
                        {{ session()->get('message') }}
                    </div>
                @endif
            </tbody>
        </table>
        {{ $options->links('pagination::bootstrap-4') }}
    </div>
@endsection
