@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Travel Locations</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data"
                action={{ route('admin.travel-location.edit', $location->id) }}>
                @csrf
                {{-- image title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Location Details
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Location<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="location_name" name="location_name"
                                    placeholder="Location Name" value="{{ $location->location_name }}">
                                @error('location_name')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Title">URL Key<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="url_key" name="url_key"
                                    placeholder="Location Name" value="{{ $location->url_key }}">
                                @error('url_key')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Timings">Short Description<span style="color: red">*</span></label>
                                <textarea class="form-control" rows="8" id="sadescription" name="short_description" placeholder="Description">{{ $location->short_description }}</textarea>
                                @error('short_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Timings">Description<span style="color: red">*</span></label>
                                <textarea class="form-control" rows="8" id="asdescription" name="location_description"
                                    placeholder="Description">{{$location->location_description}}</textarea>
                                @error('location_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>{{-- Meta details  --}}
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingSeven">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                    Meta details
                                </button>
                            </h2>
                            <div id="collapseSeven" class="accordion-collapse collapse show"
                                aria-labelledby="headingSeven">
                                <div class="accordion-body">
                                    <div class="form-group">
                                        <label for="Meta title">Meta title<span style="color: red">*</span></label>
                                        <textarea class="form-control" rows="4" id="meta_title" name="meta_title" placeholder="Meta Title">{{$location->meta_title}}</textarea>
                                        @error('meta_title')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Meta Description">Meta Description<span
                                                style="color: red">*</span></label>
                                        <textarea class="form-control" rows="8" id="meta_description" name="meta_description"
                                            placeholder="Meta Description">{{$location->meta_description}}</textarea>
                                        @error('meta_description')
                                            <span class="error">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label for="Meta Keywords">Meta Keywords<span
                                                    style="color: red">*</span></label>
                                            <textarea class="form-control" rows="8" id="meta_keywords" name="meta_keywords" placeholder="Meta Keywords">{{$location->meta_keywords}}</textarea>
                                            @error('meta_keywords')
                                                <span class="error">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
