@extends('Frontend.Mail.master')

@section('title')
    Flight mail
@endsection

@php
    $location = \App\Models\Location::find($booking->location_id);
@endphp


@section('contents')
    <tr>

        <td>

            <table cellpadding="0" cellspacing="0" style="width: 90%; margin: 0 auto; border: 1px solid #ededed">

                <tbody>

                    <tr>
                        @if ($booking->first_name)
                            <td
                                style="padding: 10px; border-bottom: 1px solid #ededed; border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                                First Name:</td>


                            <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                                {{ $booking->first_name }}</td>
                        @endif

                    </tr>

                    <tr>
                        @if ($booking->last_name)
                            <td
                                style="padding: 10px; border-bottom: 1px solid #ededed; border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                                Last name:</td>

                            <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                                {{ $booking->last_name }}</td>
                        @endif

                    </tr>

                    <tr>
                        @if ($booking->name)
                            <td
                                style="padding: 10px; border-bottom: 1px solid #ededed; border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                                Email:</td>

                            <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                                {{ $booking->email ? $booking->email : '' }}
                            </td>
                        @endif
                    </tr>

                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed; border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            Leaving from:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->leaving_from }}</td>

                    </tr>

                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            Going to:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->going_to }}</td>

                    </tr>
                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            From date:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->from_date }}</td>

                    </tr>
                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            To date:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->to_date }}</td>

                    </tr>
                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            Number of adults:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->no_of_adults }}</td>

                    </tr>
                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            Number of children:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->no_of_children }}</td>

                    </tr>
                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            Number of infants:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->no_of_infants }}</td>

                    </tr>
                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            Flight type:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->direct_flight }}</td>

                    </tr>
                    <tr>

                        <td
                            style="padding: 10px; border-bottom: 1px solid #ededed;border-right: 1px solid #ededed; width: 35%; font-weight:700; color:rgba(0,0,0,.64)">

                            Trip type:</td>

                        <td style="padding: 10px; border-bottom: 1px solid #ededed; color: #455056;">

                            {{ $booking->trip_type }}</td>

                    </tr>


                </tbody>

            </table>

        </td>

    </tr>
@endsection
