@extends('Frontend.layout.master')

@section('title')
    <title>{{ $content->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="description" content="{{ $content->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="keywords" content="{{ $content->meta_keywords }}">
@endsection

@section('page-contents')
    <section class="breadcrum" style="background-image: url({{ asset("storage/$content->banner") }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>About us</h1>
                </div>
            </div>
        </div>
    </section>


    <section class="ptb">
        <div class="container">
            <div class="row">

                
                <div class="mb-5">
                    <a href={{ route('index') }} class="back-button" >Back to home <i class="fa fa-arrow-left"></i></a>
                </div>

                <div class="col-lg-7 col-md-12">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="planning-cont">
                                {!! $content->description !!}
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-5 col-md-12 my-auto">
                    <img src="{{ asset("storage/$content->image") }}" class="img-fluid rounded shadow" alt="">
                </div>
            </div>
        </div>
    </section>


    <section class="ptb why-us" style="background-color: aliceblue;">
        <div class="container">
            <div class="row">


                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_heading_center">
                        <h2>WHY CHOOSE US?</h2>
                    </div>
                    <p class="text-center">
                        {!! $content->why_choose_us !!}
                    </p>
                </div>
            </div>
            <div class="row mt-5">
                <div class="column">
                    <div class="card">
                        <div class="icon-wrapper">
                            <i class="fas fa-thumbs-up"></i>
                        </div>
                        <h3>{{ $content->why_choose_us_1_title }}</h3>
                        <div>
                            {!! $content->why_choose_us_1_description !!}
                        </div>
                    </div>
                </div>
                <div class="column">
                    <div class="card">
                        <div class="icon-wrapper">
                            <i class="fas fa-money-bill-alt"></i>
                        </div>
                        <h3>{{ $content->why_choose_us_2_title }}</h3>
                        <div>
                            {!! $content->why_choose_us_2_description !!}
                        </div>
                    </div>
                </div>
                <div class="column">
                    <div class="card">
                        <div class="icon-wrapper">
                            <i class="fas fa-smile"></i>
                        </div>
                        <h3>{{ $content->why_choose_us_3_title }}</h3>
                        <div>
                            {!! $content->why_choose_us_3_description !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 col-md-12 mx-auto col-sm-12 ">
                    <div class="row">
                        <div class="col-lg-4 col-sm-6">
                            <div class="counter">
                                <img src="{{ asset("storage/$content->counter_1_icon") }}" alt="">
                                <span class="counter-value">{{ $content->counter_1_count }}</span>
                                <h3>{{ $content->counter_1_title }}</h3>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="counter">
                                <img src="{{ asset("storage/$content->counter_2_icon") }}" alt="">
                                <span class="counter-value">{{ $content->counter_2_count }}</span>
                                <h3>{{ $content->counter_2_title }}</h3>
                            </div>
                        </div>
                        <div class="col-lg-4 col-sm-6">
                            <div class="counter">
                                <img src="{{ asset("storage/$content->counter_3_icon") }}" alt="">
                                <span class="counter-value">{{ $content->counter_3_count }}</span>
                                <h3>{{ $content->counter_3_title }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
