@extends('Frontend.layout.master')

@section('page-contents')
    @push('scripts')
        <style>
            .form-section input[type="text"] {
                width: 100%;
                border: 2px solid #124f91;
                border-radius: 4px;
                margin: 8px 0;
                outline: none;
                height: 50px;
                box-sizing: border-box;
                transition: 0.3s;
            }

            .form-section input[type="file"] {
                width: 100%;
                border: 2px solid #124f91;
                border-radius: 4px;
                /* margin: 8px 0; */
                outline: none;
                height: 50px;
                /* line-height: 35px; */
                padding-left: 60px;
                padding-top: 9px;
                box-sizing: border-box;
                transition: 0.3s;
            }

            .form-section .inputWithIcon input[type="text"] {
                padding-left: 60px;
            }

            .form-section .inputWithIcon input[type="date"] {
                padding-left: 60px;
            }

            .form-section .inputWithIcon {
                position: relative;
            }

            .form-section .inputWithIcon i {
                position: absolute;
                left: 0;
                top: 0;
                color: #fff;
                transition: 0.3s;
            }

            .form-section .inputWithIcon.inputIconBg i {
                background-color: #124f91;
                color: #fff;
                /* padding: 9px 4px; */
                height: 50px;
                font-size: 18px;
                width: 50px;
                line-height: 50px;
                border-radius: 4px 0 0 4px;
            }

            .booking-form-img {
                height: 100%;
                width: 100%;
            }

            .booking-form-img img {
                height: 100%;
                width: 100%;
                object-fit: cover;
            }

            .c-select {
                padding-left: 55px !important;
            }
        </style>
    @endpush
    <section class="breadcrum" style="background-image: url({{ asset('Frontend/img/bookwithus/Book-With-Us.jpg') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>Careers</h1>
                </div>
            </div>
        </div>
    </section>


    @if (session()->has('message'))
        <div class="alert alert-success" style="text-align: center">
            {{ session()->get('message') }}
        </div>
    @endif


    <section class="form-section ptb">
        <div class="container bg-light rounded border">
            <div class="row">

                <div class="col-lg-4 px-0">
                    <div class="booking-form-img">
                        <img src="https://img.freepik.com/free-photo/cute-pretty-young-woman-smartphone-cafe_346278-197.jpg?w=360&t=st=1684328710~exp=1684329310~hmac=a2fb62f30c575f14aafce628e93ec4a8ffbf59c6cfa74c7a0a8ff585e3b1b42f"
                            alt="">
                    </div>
                </div>
                <div class="col-lg-8 mx-auto">
                    <form action="{{ route('career') }}" method="POST" class="contact-one__form " enctype="multipart/form-data">
                        @csrf
                        <div class="form-group" style="display: none;">
                            <label for="faxonly">Fax Only
                                <input type="checkbox" name="faxonly" id="faxonly" />
                            </label>
                        </div>
                        <input type="hidden" value="contact.php" name="dsfdssdf">
                        <div class="section-title">
                            <h2 class="section-title__title">CONTACT INFORMATION</h2>
                        </div>
                        <div class="row form-section">
                            <div class="col-lg-12 col-md-12">
                                <div class="inputWithIcon inputIconBg">
                                    <select name="location_id" id="location_id" class="c-select">
                                        <option value="">Select Location</option>
                                        @foreach ($locations as $location)
                                            <option value="{{ $location->id }}">
                                                {{ $location->title }} </option>
                                        @endforeach
                                    </select>
                                    <i class="fas fa-map-marker-alt fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="text" placeholder="First name" name="first_name" required oninput="validateInput(this)">
                                    <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="text" placeholder="Last name" name="last_name" required oninput="validateInput(this)">
                                    <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="text" placeholder="Phone number" name="phone_number"  id="phone_number" onkeypress="return onlyNumberKey(event)" maxlength="15" minlength="10" required>
                                    <i class="fa fa-phone fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="text" placeholder="Email address" name="email" required>
                                    <i class="fa fa-envelope fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <div class="inputWithIcon inputIconBg">
                                    <select name="status_in_canada" id="status_in_canada" class="c-select">
                                        <option value="">Status in Canada</option>
                                        <option value="Citizen">Citizen</option>
                                        <option value="Permanent Resident">Permanent Resident</option>
                                        <option value="Work Permit">Work Permit</option>
                                        <option value="Student (Study Permit)">Student (Study Permit)</option>
                                        <option value="Student (Under 18)">Student (Under 18)</option>
                                        <option value="Others">Others</option>
                                    </select>
                                    <i class="fas fa-user-headset fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <div class="inputWithIcon inputIconBg">
                                    <select name="position" id="position" class="c-select">
                                        <option value="">Select Position</option>
                                        <option value="Customer Service">Customer Service</option>
                                        <option value="Travel Consultant">Travel Consultant</option>
                                        <option value="Marketing">Marketing</option>
                                        <option value="Others">Others</option>
                                    </select>
                                    <i class="fas fa-user-headset fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="text" placeholder="City" name="city" required>
                                    <i class="fas fa-map-marker-alt fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="text" placeholder="Province" name="province" required>
                                    <i class="fas fa-map-marker-alt fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="text" placeholder="Postal Code" name="postal_code" required>
                                    <i class="fas fa-map-marker-alt fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="inputWithIcon inputIconBg">
                                    <input type="file"  accept="application/pdf" placeholder="Resume" name="file" required>
                                    <i class="fas fa-file-pdf fa-lg fa-fw" aria-hidden="true"></i>
                                </div>
                            </div>

                            <div class="col-lg-12 col-md-12">
                                <div class="inputWithIcon inputIconBg">
                                    <i class="fas fa-map-marker-alt fa-lg fa-fw" aria-hidden="true"></i>
                                    <textarea name="address" placeholder="Address" required oninput="validateInput(this)"></textarea>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12">
                                <div class="inputWithIcon inputIconBg">
                                    <i class="fa fa-comments fa-lg fa-fw" aria-hidden="true"></i>
                                    <textarea name="message" placeholder="Write message" required oninput="validateInput(this)"></textarea>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="g-recaptcha mb-2" data-sitekey="6LehSssqAAAAAE1CPQLjLoZY7dnh4UycWmweSUlt" data-callback="correctCaptcha"></div>
                            </div>
                            <div class="col-md-6">
                                <button class="button2" type="submit" name="dfgfshdhdf" disabled id="submitButton">
                                    <span>send a message</span>
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="result"></div>
                </div>

            </div>
        </div>
    </section>

    {{-- <section class="">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 px-0">
                    <iframe src="{{ $content->map_link }}" width="100%" height="450" style="border:0;"
                        allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>

            </div>
        </div>
    </section> --}}
    <script>
        function validateInput(input) {
            // Remove special characters except letters and spaces
            input.value = input.value.replace(/[^a-zA-Z\s]/g, '');
        }
        function onlyNumberKey(evt) {
            var ASCIICode = (evt.which) ? evt.which : evt.keyCode
            if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
                return false;
            return true;
        }
        function correctCaptcha() {
            $('#submitButton').attr('disabled', false);
        }
    </script>
@endsection
