@extends('Frontend.layout.master')

@section('title')
    <title>{{ $content->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="description" content="{{ $content->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="keywords" content="{{ $content->meta_keywords }}">
@endsection

@section('page-contents')
    <section class="breadcrum" style="background-image: url({{ asset("storage/$content->banner") }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>Contact Us</h1>
                </div>
            </div>
        </div>
    </section>


    @if (session()->has('message'))
        <div class="alert alert-success" style="text-align: center">
            {{ session()->get('message') }}
        </div>
    @endif

    <section class="contact-one ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <form action="{{ route('contact-us-query') }}" method="POST" class="contact-one__form ">
                        @csrf
                        <div class="form-group" style="display: none;">
                            <label for="faxonly">Fax Only
                                <input type="checkbox" name="faxonly" id="faxonly" />
                            </label>
                        </div>
                        <input type="hidden" value="contact.php" name="dsfdssdf">
                        <div class="section-title">
                            <h2 class="section-title__title">CONTACT INFORMATION</h2>
                        </div>
                        <div class="row ">
                            <input type="hidden" name="contact_us_email" id="contact_us_email"
                                value="{{ $content->email }}">
                            <div class="col-lg-6 col-md-12">
                                <input type="text" placeholder="First name" name="first_name" id="name" required oninput="validateInput(this)">
                                @error('first_name')
                                    <span style="color:red;font-size:13px;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <input type="text" placeholder="Last name" name="last_name" id="name" required oninput="validateInput(this)">
                                @error('last_name')
                                    <span style="color:red;font-size:13px;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <input type="text" placeholder="Telephone" name="phone_number" id="phone_number"
                                    onkeypress="return onlyNumberKey(event)" maxlength="15" minlength="10" required>
                                @error('phone_number')
                                    <span style="color:red;font-size:13px;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-6 col-md-12">
                                <input type="email" placeholder="Email address" name="email" required>
                                @error('email')
                                    <span style="color:red;font-size:13px;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-12 col-md-12">
                                <select id="service_type" name="service_type" required>
                                    <option value="">Select Service Type</option>
                                    <option value="Travel">Travel</option>
                                    <option value="Cruises">Cruises</option>
                                    <option value="Vacation">Vacation</option>
                                    <option value="Group Travel">Group Travel</option>
                                    <option value="Destination Wedding">Destination Wedding</option>
                                    <option value="Others">Others</option>
                                </select>
                            </div>
                            <div class="col-lg-12 col-md-12">
                                <textarea name="message" placeholder="Comments" oninput="validateInput(this)"></textarea>
                                @error('message')
                                    <span style="color:red;font-size:13px;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-12">
                                <div class="g-recaptcha mb-2" data-sitekey="6LehSssqAAAAAE1CPQLjLoZY7dnh4UycWmweSUlt" data-callback="correctCaptcha"></div>
                            </div>
                            <div class="col-md-6">
                                <button class="button2" type="submit" name="dfgfshdhdf" disabled id="submitButton">
                                    <span>send a message</span>
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="result"></div>
                </div>
                <div class="col-lg-4">
                    <div class="contact-one__info" style="background-image: url(./assets/img/contact-one-bg-1-1.png);">
                        <div class="contact-one__item">
                            <h3 class="contact-one__item__title">ADDRESS</h3>
                            <p class="contact-one__item__text">{{ $content->address }}</p>
                        </div>
                        <div class="contact-one__item">
                            <h3 class="contact-one__item__title">TEL NO</h3>
                            <p class="contact-one__item__text"><a href="">{!! $content->phone_number !!}</a></p>


                        </div>
                        <div class="contact-one__item">
                            <h3 class="contact-one__item__title">EMAIL</h3>
                            <p class="contact-one__item__text"><a
                                    href="mailto:{{ $content->email }}">{{ $content->email }}</a></p>

                        </div>
                        <div class="contact-one__item">
                            <ul class="contact-one__social">
                                <li><a href="{{ $content->facebook_link }}"><i class="fab fa-facebook-f"></i></a></li>
                                <li><a href="{{ $content->instagram_link }}"><i class="fab fa-instagram"></i></a></li>
                                <li><a href="{{ $content->twitter_link }}"><i class="fab fa-twitter"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 px-0">
                    <iframe src="{{ $content->map_link }}" width="100%" height="450" style="border:0;"
                        allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>

            </div>
        </div>
    </section>
    @push('scripts')
        <script>
            function validateInput(input) {
                // Remove special characters except letters and spaces
                input.value = input.value.replace(/[^a-zA-Z\s]/g, '');
            }
            function onlyNumberKey(evt) {
                var ASCIICode = (evt.which) ? evt.which : evt.keyCode
                if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
                    return false;
                return true;
            }
            function correctCaptcha() {
                $('#submitButton').attr('disabled', false);
            }
        </script>
    @endpush
@endsection
