@extends('Frontend.layout.master')

@section('title')
    <title>{{ $cruise_ship_options->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="description" content="{{ $cruise_ship_options->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="keywords" content="{{ $cruise_ship_options->meta_keywords }}">
@endsection

@section('page-contents')
    {{-- <section class="breadcrum" style="background-image: url(./assets/img/cruise/cruise03.jpg); "> --}}
    <section class="breadcrum" style="background-image: url({{ asset("storage/$cruise_ship_options->banner") }}); ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>Cruise Ship Options</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="ptb">
        <div class="container">

            <div class="mb-5 row">
                <div class="col-lg-3 ms-auto">
                    <a href={{ route('index') }} class="back-button">Back to home <i class="fa fa-arrow-left"></i></a>
                </div>

            </div>

            <div class="row ship-option-sec">
                <div class="col-lg-7">
                    <img src="{{ asset("storage/$cruise_ship_options->header_image_1") }}" class="img-fluid" alt="">
                    <div class="row">
                        <div class="col-lg-9 py-5">
                            <h2 class="mb-4">{{ $cruise_ship_options->header_title }}</h2>
                            <p>
                                {!! $cruise_ship_options->header_description !!}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5">
                    <img src="{{ asset("storage/$cruise_ship_options->header_image_2") }}" class="img-fluid option-long"
                        alt="">
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row">


                <div class="col-lg-5">
                    <div class="ship-option-cont">
                        <h3>Popular : <span>{{ $cruise_ship_options->popular_title }}</span> </h3>
                        <p>
                            {!! $cruise_ship_options->popular_description !!}
                        </p>
                    </div>
                </div>
                <div class="col-lg-7 px-0">
                    {{-- <img src="./assets/img/cruise/h3-video-background-img-1.jpg" class="img-fluid" alt=""> --}}
                    <img src="{{ asset("storage/$cruise_ship_options->popular_image") }}" class="img-fluid" alt="">
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row">
                <div class="col-lg-5 px-0">
                    <img src="{{ asset("storage/$cruise_ship_options->premium_image") }}" class="img-fluid" alt="">
                </div>
                <div class="col-lg-7">
                    <div class="row">
                        <div class="col-lg-9">
                            <div class="ship-option-cont1">
                                <h3>Premium : <span>{{ $cruise_ship_options->premium_title }}</span> </h3>
                                <p>
                                    {!! $cruise_ship_options->premium_description !!}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="ship-option-cont">
                        <h3>Luxury : <span>{{ $cruise_ship_options->luxury_title }}</span> </h3>
                        <p>
                            {!! $cruise_ship_options->luxury_description !!}
                        </p>
                    </div>
                </div>
                <div class="col-lg-7 px-0">
                    <img src="{{ asset("storage/$cruise_ship_options->luxury_image") }}" class="img-fluid" alt="">
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row">
                <div class="col-lg-5 px-0">
                    <img src="{{ asset("storage/$cruise_ship_options->river_cruises_image") }}" class="img-fluid"
                        alt="">
                </div>
                <div class="col-lg-7">
                    <div class="row">
                        <div class="col-lg-9">
                            <div class="ship-option-cont1">
                                <h3>River cruises : <span>{{ $cruise_ship_options->river_cruises_title }}</span> </h3>
                                <p>
                                    {!! $cruise_ship_options->river_cruises_description !!}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="book-view">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 my-auto">
                    <h2 class="text-white">Discover, explore, and book your next adventure with us today !</h2>
                </div>
                <div class="col-lg-4 my-auto ms-auto">
                    <a href="{{ route('booking-forms', ['page_name' => $cruise_ship_options->header_title]) }}" class="text-decoration-none">
                        <button class="book-now">
                            <span class="text">Book with us</span>
                            <span class="icon"><svg aria-hidden="true" width="20px" data-icon="paper-plane"
                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path fill="currentColor"
                                        d="M476 3.2L12.5 270.6c-18.1 10.4-15.8 35.6 2.2 43.2L121 358.4l287.3-253.2c5.5-4.9 13.3 2.6 8.6 8.3L176 407v80.5c0 23.6 28.5 32.9 42.5 15.8L282 426l124.6 52.2c14.2 6 30.4-2.9 33-18.2l72-432C515 7.8 493.3-6.8 476 3.2z">
                                    </path>
                                </svg></span>
                        </button>
                    </a>
                </div>
            </div>
        </div>
    </section>
@endsection
