@extends('Frontend.layout.master')

@section('title')
    <title>{{ $cruise_vacation->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="description" content="{{ $cruise_vacation->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="keywords" content="{{ $cruise_vacation->meta_keywords }}">
@endsection
@section('page-contents')
    <section class="breadcrum" style="background-image: url({{ asset("storage/$cruise_vacation->banner") }}); ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>{{ $cruise_vacation->title }}</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="book-view">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 my-auto">
                    <h2 class="text-white">Discover, explore, and book your next adventure with us today !</h2>
                </div>
                <div class="col-lg-4 my-auto ms-auto">
                   <a href="{{ route('cruise-vacation.booking') }}" class="text-decoration-none">
                        <button class="book-now">
                            <span class="text">Book with us</span>
                            <span class="icon"><svg aria-hidden="true" width="20px" data-icon="paper-plane" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M476 3.2L12.5 270.6c-18.1 10.4-15.8 35.6 2.2 43.2L121 358.4l287.3-253.2c5.5-4.9 13.3 2.6 8.6 8.3L176 407v80.5c0 23.6 28.5 32.9 42.5 15.8L282 426l124.6 52.2c14.2 6 30.4-2.9 33-18.2l72-432C515 7.8 493.3-6.8 476 3.2z"></path></svg></span>
                        </button>
                   </a>
                </div>
            </div>
        </div>
    </section>


    <section class="vacation-section">
        <div class="container">
            <div class="row">

          

                <div class="col-lg-12 content">
                    <div class="row">
                        <div class="col-lg-5 col-md-12 col-sm-12">
                            <img src="{{ asset("storage/$cruise_vacation->section_1_image") }}" class="img-fluid"
                                alt="">
                        </div>
                        <div class="col-lg-7 col-md-12 col-sm-12 content-heading my-auto">
                            <h1> {{ $cruise_vacation->section_1_title }}</h1>
                            {!! $cruise_vacation->section_1_description !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="vacation-detail">
        <div class="container">
            <div class="row">

                         
            <div class="mt-5">
                <a href={{ route('index') }} class="back-button" >Back to home <i class="fa fa-arrow-left"></i></a>
            </div>

                <div class="col-lg-12 col-md-12 bg-white mt-5 pt-5 content-heading">
                    <div class="row">
                        <div class="col-lg-5 cruise-img1">
                            <img src="{{ asset("storage/$cruise_vacation->section_2_image") }}" class="img-fluid"
                                alt="">
                        </div>
                        <div class="col-lg-7 my-auto">
                            <h6 class="mb-4">
                                {{ $cruise_vacation->section_2_title }}
                            </h6>
                            {!! $cruise_vacation->section_2_description !!}
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 col-md-12 bg-white mt-5 pt-5 content-heading">
                    <div class="row">
                        <div class="col-lg-7">
                            <h6 class="mb-4">
                                {{ $cruise_vacation->section_3_title }}
                            </h6>
                            {!! $cruise_vacation->section_3_description !!}
                        </div>
                        <div class="col-lg-5 cruise-img1">
                            <img src="{{ asset("storage/$cruise_vacation->section_3_image") }}" alt=""
                                class="img-fluid">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="vacation-section" style="background-color: #4DB2DC;">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 content">
                    <div class="row">
                        <div class="col-lg-7 col-md-12 col-sm-12 content-heading my-auto">
                            {!! $cruise_vacation->section_4_description !!}
                        </div>
                        <div class="col-lg-5 col-md-12 col-sm-12">
                            <img src="{{ asset("storage/$cruise_vacation->section_4_image") }}" class="img-fluid"
                                alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
