@extends('Frontend.layout.master')


@section('title')
    <title>{{ $content->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="description" content="{{ $content->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="keywords" content="{{ $content->meta_keywords }}">
@endsection

@section('page-contents')
    @push('styles')
        <style>
            .contact_detail p {
                font-size: 17px;
                font-weight: 700;
                color: black;
            }

            .contact_detail a {
                font-size: 17px;
                font-weight: 800;
                color: black !important;
            }
            .input-group-form label {
                font-size: 15px;
                margin-bottom: 7px;
                padding-left: 10px;
            }

            .input-group-form label i {
                /* width: 25px; */
                margin-right: 5px;
                font-size: 20px;
                color: #014B9A;
            }

            .input-group-form input {
                height: 50px;
                width: 100%;
                border: 1px solid #014B9A;
                outline: none;
                padding: 0 15px;
                font-size: 14px;
                /* border-radius: 10px; */
                transition: .4s all;
            }

            .input-group-form select {
                height: 50px;
                width: 100%;
                border: 1px solid #014B9A;
                outline: none;
                padding: 0 15px;
                font-size: 14px;
                /* border-radius: 10px; */
                transition: .4s all;
            }

            .input-group-form input:focus {
                border-color: #014B9A;
            }

            .input-group-form input[type="checkbox"] {
                height: 20px;
                width: 20px;
            }

            .search-btn1 {
                cursor: pointer;
                transition: all .2s;
                padding: 10px 30px;
                text-align: center;
                border-radius: 5px;
                background: #fff;
                border: 1px solid #014B9A;
                display: flex;
                justify-content: center;
                align-items: center;
                font-size: 16px;
                text-decoration: none;
                color: #000;
                margin: auto;
            }

            .search-btn1:hover {
                color: #fff;
                background-color: #014B9A;
            }
        </style>
    @endpush
    {{-- <section class="main-banner" style="background-image: url({{ asset("storage/$content->banner") }}); ">
        <div class="container">
            <div class="row">
                <h1 class="banner-title">{{ $content->title }}</h1>
                <p>Find awesome flights, hotel, tour, car and packages</p>
            </div>
        </div>
    </section> --}}

    <section class="main-1">
        <div class="swiper mySwiper">
            <div class="swiper-wrapper">
                @foreach ($banners as $banner)
                    <div class="swiper-slide">
                        <div class="banner-slider" style="background-image: url({{ asset("storage/$banner->banner") }});">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h1 class="banner-title">{{ $banner->title }}</h1>
                                </div>
                                <div class="col-lg-12 text-center">
                                    <p class="text-white fs-5">{{ $banner->description }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
                {{-- <div class="swiper-slide">
                    <div class="banner-slider" style="background-image: url(./assets/img/banner/tourism.jpg);">
                        <div class="row">
                            <div class="col-lg-12">
                                <h1 class="banner-title">Explore the world together</h1>
                            </div>
                            <div class="col-lg-12 text-center">
                                <p class="text-white fs-5">Find awesome flights, hotel, tour, car and packages</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="banner-slider" style="background-image: url(./assets/img/banner/vacations-banner.png);">
                        <div class="row">
                            <div class="col-lg-12">
                                <h1 class="banner-title">Vacation</h1>
                            </div>
                            <div class="col-lg-12 text-center">
                                <p class="text-white fs-5">Find awesome flights, hotel, tour, car and packages</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="banner-slider"
                        style="background-image: url(./assets/img/banner/cruise-vacation-banner.png);">
                        <div class="row">
                            <div class="col-lg-12">
                                <h1 class="banner-title">Cruise</h1>
                            </div>
                            <div class="col-lg-12 text-center">
                                <p class="text-white fs-5">Find awesome flights, hotel, tour, car and packages</p>
                            </div>
                        </div>
                    </div>
                </div> --}}
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <div class="swiper-pagination"></div>
        </div>

    </section>

    <section class="about-sec bg-light">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-2 abt-heading">
                    <h1>Our Mission</h1>
                </div>
                <div class="col-lg-5 my-auto">
                    <div class="abt-cont">
                        <h3>{{ $content->about_us_title }}</h3>
                        <p>
                            {!! $content->about_us_description !!}
                        </p>
                    </div>
                </div>
                <div class="col-lg-5 text-left abt-img my-auto">
                    <img class="img-fluid" src="{{ asset("storage/$content->about_us_image") }}" alt="">
                </div>
            </div>
        </div>
    </section>

    @if (session()->has('message'))
        <div class="alert alert-success" style="text-align: center">
            {{ session()->get('message') }}
        </div>
    @endif
    <section class="ptb pb-0">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <form action="{{ route('flight-booking') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group" style="display: none;">
                            <label for="faxonly">Fax Only
                                <input type="checkbox" name="faxonly" id="faxonly" />
                            </label>
                        </div>
                        <div class="row">

                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-map-marker-alt fa-lg fa-fw"></i>
                                        Select location
                                    </label>
                                    <select name="location_id" id="location_id">
                                        <option value="">Select Location</option>
                                        @foreach ($locations as $location)
                                            <option {{ old('location_id') == $location->id ? 'selected' : '' }}
                                                value="{{ $location->id }}">
                                                {{ $location->title }} </option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('location_id')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-plane-departure"></i>
                                        Leaving From
                                    </label>
                                    <input type="text" placeholder="Leaving From" value="{{ old('leaving_from') }}"
                                        name="leaving_from" required>
                                </div>
                                @error('leaving_from')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-plane-arrival"></i>
                                        Going To
                                    </label>
                                    <input type="text" placeholder="Going To" name="going_to"
                                        value="{{ old('going_to') }}" required>
                                </div>
                                @error('going_to')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-calendar-check"></i>
                                        Departing On
                                    </label>
                                    <input type="date" name="from_date" required value="{{ old('from_date') }}">
                                </div>
                                @error('from_date')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-calendar-check"></i>
                                        Returning On
                                    </label>
                                    <input type="date" name="to_date" required value="{{ old('to_date') }}">
                                </div>
                                @error('to_date')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-male"></i>
                                        No. of Adults
                                    </label>
                                    <input type="number" value="{{ old('no_of_adults') }}" placeholder="No. of Adults"
                                        name="no_of_adults" id="adult">
                                </div>
                                @error('no_of_adults')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-child"></i>
                                        No. of Children
                                    </label>
                                    <input type="number" value="{{ old('no_of_children') }}"
                                        placeholder="No. of Children" name="no_of_children" id="child">
                                </div>
                                @error('no_of_children')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fad fa-baby"></i>
                                        No. of Infants
                                    </label>
                                    <input type="number" value="{{ old('no_of_infants') }}"
                                        placeholder="No. of Infants" name="no_of_infants" id="infant">
                                </div>
                                @error('no_of_infants')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-4 ms-auto mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-user"></i>
                                        Name
                                    </label>
                                    <input type="text" placeholder="Name" name="name" required
                                        value="{{ old('name') }}" oninput="validateInput(this)">
                                </div>
                                @error('name')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-4 ms-auto mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-phone-alt"></i>
                                        Telephone
                                    </label>
                                    <input type="text" placeholder="Telephone" name="phone" minlength="10"
                                        maxlength="15" oninput="this.value = this.value.replace(/\D/g, '')" required
                                        value="{{ old('phone') }}">
                                </div>
                                @error('phone')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-4 ms-auto mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-envelope-open"></i>
                                        Email
                                    </label>
                                    <input type="email" placeholder="Email" name="email" required
                                        value="{{ old('email') }}">
                                </div>
                                @error('email')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-3 mt-4">
                                <div class="pt-3">
                                    <div class="form-check pt-4">
                                        <input class="form-check-input" type="checkbox" value="1"
                                            name="direct_flight" id="flexCheckDefault">

                                        <label class="form-check-label" for="flexCheckDefault">
                                            Direct Flights Only
                                        </label>
                                    </div>
                                </div>
                                @error('direct_flight')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-9 mt-4 ">
                                <div class="Journey_date pt-4">
                                    <div class="form-check form-check-inline pt-1">
                                        <input class="form-check-input" type="radio" name="trip_type"
                                            id="inlineRadio1" value="Round trip" checked>
                                        <label class="form-check-label" for="Round trip">Round
                                            Trip</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" name="trip_type"
                                            id="inlineRadio2"
                                            value="Multiple
                                        Destinations">
                                        <label class="form-check-label" for="Multiple destinations">Multiple
                                            Destinations</label>
                                    </div>
                                </div>
                                @error('trip_type')
                                    <span style="font-size:10px;color:red;">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-12 mt-4">
                                <div class="input-group-form">
                                    <label for="">
                                        <i class="fas fa-comments"></i>
                                        Comments
                                    </label>
                                    <input type="text" placeholder="Comments" name="comments"
                                        value="{{ old('comments') }}" oninput="validateInput(this)">
                                </div>
                            </div>
                            <div class="col-lg-12 mt-3">
                                <div class="g-recaptcha mb-2" data-sitekey="6LehSssqAAAAAE1CPQLjLoZY7dnh4UycWmweSUlt" data-callback="correctCaptcha"></div>
                            </div>

                            <div class="col-lg-12 mx-auto mt-5 text-center">
                                <button type="submit" class="search-btn1 text-decoration-none" disabled id="submitButton">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <section id="offer_area" class="ptb">
        <div class="container mt-5">
            <div class="row">
                @foreach ($home_images as $home_image)
                    <div class="col-lg-3 col-md-12 col-sm-12 col-12">
                        <a href="{{ $home_image->link }}" style="text-decoration: none">
                            <div class="offer_area_box d-none-phone img_animation"><img
                                    src="{{ asset("storage/$home_image->image") }}" alt="img">
                                <div class="offer_area_content">
                                    <h2>{{ $home_image->title }}</h2>
                                    <div>{!! $home_image->description !!}</div>
                                    <a href="{{ $home_image->link }}" class="button-sm text-decoration-none">Quote
                                        Request</a>
                                </div>
                            </div>
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </section>



    <section class="solution1-section" style="background-image: url({{ asset("storage/$content->read_more_image") }})">
        <div class="container-fluid">
            <div class="row ">
                <div class="col-lg-4 col-md-6 px-0 col-sm-12 ms-auto">
                    <div class="solution-content-right">
                        <!-- <h4 class="Title wow fadeInUp" data-wow-delay=".6s" data-wow-duration="1.5s">-SOLUTIONS-</h4> -->
                        <h1 class="wow fadeInUp" data-wow-delay=".7s" data-wow-duration="1.5s">
                            {{ $content->read_more_title }}</h1>
                        <p class="wow fadeInUp" data-wow-delay=".8s" data-wow-duration="1.5s">
                            {!! $content->read_more_description !!}
                        </p>

                        <div class="col-md-12 mt-5  wow flipInX" data-wow-delay=".6s" data-wow-duration="1.5s">
                            <a href="{{ $content->read_more_link }}" class="button2 text-decoration-none">Read more</a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <section class="package-sec ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-2"></div>
                <div class="col-lg-4 col-md-6 col-sm-12 col-12">

                    <div class="section_heading_center">
                        <h2>Destinations for you</h2>
                    </div>
                </div>
                <div class="col-lg-1"></div>
                <div class="col-lg-3">
                    <select name="location" id="location">
                        <option value="">Select Location</option>
                        @foreach ($locations as $location)
                            <option value="{{ route('location_detail', $location->slug) }}">
                                {{ $location->title }} </option>
                        @endforeach

                    </select>
                </div>

                <div id="package">

                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <div class="row">
                            @foreach ($destinations as $destination)
                                <div class="col-lg-6">
                                    <div class="tab_destinations_boxed">
                                        <div class="tab_destinations_img">
                                            <a href="#" class="">
                                                <img src="{{ asset("storage/$destination->image") }}" alt="img">
                                            </a>
                                        </div>
                                        <div class="tab_destinations_conntent">
                                            <h3>{{ $destination->package_name }}</h3>
                                            {!! $destination->package_details !!}
                                        </div>
                                        <div class="price-tab text-center">
                                            <div class="price">
                                                <h3>${{ $destination->price }}</h3>
                                                <p>{{ $destination->price_note }}</p>
                                            </div>
                                            <div class="book">
                                                <a href="{{ route('booking-pacakage-forms', $destination->id) }}"
                                                    style="text-decoration:none">
                                                    <h6>BOOK</h6>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            {{-- {{ $destinations }} --}}
                            {{-- {{ $destinations->links('pagination::bootstrap-4') }} --}}
                        </div>
                    </div>

                    <div class="col-lg-12 text-center">
                        <a href="{{ route('allpackages') }}" style="display: inline-block;text-decoration:none;">
                            <button class="loadmore">
                                <span class="moreless-button"> Load More</span>
                                <div class="arrow-wrapper">
                                    <div class="arrow"></div>
                                </div>
                            </button>
                        </a>
                    </div>


                </div>

            </div>
        </div>
    </section>

    <section class="">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_heading_center">
                        <h2> Special Offers</h2>
                    </div>
                </div>
                {{-- <div class="col-lg-12 mx-auto">
                    <div id="airline" class="owl-carousel owl-theme offer mt-4 owl-loaded owl-drag">
                        <div class="item">

                            <div class="col-lg-12">

                                @if ($content->special_offer_banner_1_link)
                                    <a href="{{ route($content->special_offer_banner_1_link) }}">
                                        <img src="{{ asset("storage/$content->special_offer_banner_1") }}"
                                            class="img-fluid rounded" alt="" srcset="">
                                    </a>
                                @else
                                    <a href="{{ route('indian-tourist-destinations') }}">
                                        <img src="{{ asset("storage/$content->special_offer_banner_1") }}"
                                            class="img-fluid rounded" alt="" srcset="">
                                    </a>
                                @endif
                            </div>
                        </div>
                        <div class="item">
                            <div class="col-lg-12">
                                @if ($content->special_offer_banner_2_link)
                                    <a href="{{ route($content->special_offer_banner_2_link) }}">
                                        <img src="{{ asset("storage/$content->special_offer_banner_2") }}"
                                            class="img-fluid rounded" alt="" srcset="">
                                    </a>
                                @else
                                    <a href="{{ route('indian-tourist-destinations') }}">
                                        <img src="{{ asset("storage/$content->special_offer_banner_2") }}"
                                            class="img-fluid rounded" alt="" srcset="">
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                </div> --}}

                <div class="col-lg-6 mx-auto">
                    <div class="owl-carousel owl-theme offer mt-4 owl-loaded owl-drag"
                        style="background-image: url({{ asset("storage/$content->special_offer_banner_1") }});">
                        <div class="item">
                            <div class="col-lg-6 col-7 ms-auto mt-4">
                                <div class="offer-detail">
                                    <!--<h4>Special rates for passengers comming from India to Toronto </h4>-->
                                    <!--<div class="contact_detail">-->
                                    <!--    <p>Please call us for more details <br>-->
                                    <!--        <a style="text-decoration: none" href="tel:905-671-8400">905-671-8400</a>-->
                                    <!--    </p>-->
                                    <!--</div>-->

                                    {{-- <a href="{{ route('indian-tourist-destinations') }}"
                                        style="text-decoration: none">Know More</a> --}}
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="col-lg-6 col-7 ms-auto mt-4">
                                <div class="offer-detail">
                                    <!--<h4>Special rates for passengers comming from India to Toronto </h4>-->
                                    <!--<div class="contact_detail">-->
                                    <!--    <p>Please call us for more details <br><a style="text-decoration: none"-->
                                    <!--            href="tel:905-671-8400">905-671-8400</a></p>-->
                                    <!--</div>-->
                                    {{-- <a href="{{ route('indian-tourist-destinations') }}"
                                        style="text-decoration: none">Know More</a> --}}
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-lg-6 mx-auto">
                    <div class="owl-carousel owl-theme offer mt-4 owl-loaded owl-drag"
                        style="background-image: url({{ asset("storage/$content->special_offer_banner_2") }});">
                        <div class="item">
                            <div class="col-lg-6 col-7 ms-auto mt-4">
                                <div class="offer-detail">
                                    <!--<h4>Looking for all inclusive vacation packages or cruise in month of June 2023</h4>-->
                                    <!--<div class="contact_detail">-->
                                    <!--    <p>Call us for more info. <br> <a style="text-decoration: none"-->
                                    <!--            href="tel:905-671-8400">905-671-8400</a> </p>-->
                                    <!--</div>-->
                                    {{-- <a href="" style="text-decoration: none">Know More</a> --}}
                                </div>
                            </div>
                        </div>
                        <div class="item">
                            <div class="col-lg-6 col-7 ms-auto mt-4">
                                <div class="offer-detail">
                                    <!--<h4>Looking for all inclusive vacation packages or cruise in month of June 2023</h4>-->
                                    <!--<div class="contact_detail">-->
                                    <!--    <p>Call us for more info. <br> <a style="text-decoration: none"-->
                                    <!--            href="tel:905-671-8400">905-671-8400</a> </p>-->
                                    <!--</div>-->
                                    {{-- <a href="" style="text-decoration: none">Know More</a> --}}
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>


        </div>
        </div>
    </section>

    <section class="airlines mt-70 mb-5 pb-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_heading_center">
                        <h2>Airlines</h2>
                    </div>
                </div>
                <div id="airline" class="owl-carousel owl-theme airline mt-4 owl-loaded owl-drag">
                    @foreach ($home_airlines as $home_airline)
                        <div class="item">
                            <div class="airline-sec col-lg-12 my-auto mx-auto">
                                <img src="{{ asset("storage/$home_airline->image") }}" class="img-fluid pt-2"
                                    alt="">
                            </div>
                        </div>
                    @endforeach

                </div>
            </div>
        </div>
    </section>

    <section class="">
        <div class="container-fluid ">
            <div class="row ">
                <div class="col-lg-12 px-0">
                    <div>
                        <div>
                            <img src="{{ asset("storage/$content->new_letter_image") }}" class="w-100" alt="a"
                                decoding="async" loading="lazy">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="newsletter">
        <div class="container">
            <div class="row">
                <form action="{{ route('newsletter.store') }}" method="POST">
                    @method('POST')
                    @csrf
                    <div class="form-group" style="display: none;">
                        <label for="faxonly">Fax Only
                            <input type="checkbox" name="faxonly" id="faxonly" />
                        </label>
                    </div>
                    <div class="col-lg-6">
                        <h2> <strong>Subscribe To</strong> The Newsletter</h2>
                        <input type="email" placeholder="Your Email..." name="email" required>
                        @error('email')
                            <small style="color: red;">{{ $message }}</small>
                        @enderror
                        <button type="submit" class="button">Subscribe</button>
                    </div>
                </form>
            </div>
        </div>
    </section>
    <div class="qodef-row-overlapping-text qodef-appear">AWAY</div>


    <section class="testimonial ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_heading_center">
                        <h2>Testimonials</h2>

                    </div>
                </div>
                <div id="reviews" class="owl-carousel owl-theme reviews owl-loaded owl-drag">
                    @foreach ($home_testimonials as $home_testimonial)
                        <div class="item">
                            <div class="review-sec col-lg-11 mx-auto">
                                <div class="row">
                                    <div class="col-lg-2">
                                        <div class="review-img">
                                            <img src="{{ asset("storage/$home_testimonial->image") }}" alt="">
                                        </div>
                                    </div>
                                    <div class="col-lg-10">
                                        <h3>{{ $home_testimonial->name }}</h3>
                                        <div>{{ $home_testimonial->post }}</div>
                                    </div>
                                </div>
                                <div class="star-sec mb-3">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                </div>
                                <div>{!! $home_testimonial->description !!}</div>

                                <img src="{{ asset('Frontend/img/left-quotes-sign.png') }}" class="left-quote"
                                    alt="">
                                <img src="{{ asset('Frontend/img/left-quotes-sign.png') }}" class="right-quote"
                                    alt="">
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script>
        $('.book').on('change', function() {
            var $this = $(this);
            var id = $this.attr("id");
            // alert(id);
            var count = $(this).val();
            for (i = 0; i < count; i++) {
                let details = $('#details');
                details.append(`
                            <div class="row item mt-2">
                                <input type="hidden" name="type[]" value=${id}>
                                <div class="col-lg-3"></div>
                                <div class="form-group col-lg-4" >
                                    <label for="Name" class="form-check-label text-white">Name<span style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="name" name="names[]"
                                        placeholder="Name" required>
                                    @error('name')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="Age" class="form-check-label text-white">Age<span style="color: red">*</span></label>
                                    <input type="number" class="form-control" id="age" name="age[]"
                                        placeholder="Age" required>
                                    @error('age')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div> 
                                <div class="col-lg-1 my-auto">
                            <button type="button" class="btn btn-danger remove mt-4">X</button>
                        </div>
                            </div>
                        `);
            }
        });
        // $('#children').on('change', function() {
        //     var count = $(this).val();
        //     for (i = 0; i < count; i++) {
        //         let details = $('#details');
        //         details.append(`
    //                     <div class="row item">
    //                         <input type="hidden" name="type[]" value="1">
    //                         <div class="form-group col-lg-5">
    //                             <label for="Name" class="form-check-label text-white">Name<span style="color: red">*</span></label>
    //                             <input type="text" class="form-control" id="name" name="child_name[]"
    //                                 placeholder="Name" required>
    //                             @error('name')
    //                                 <span class="error">{{ $message }}</span>
    //                             @enderror
    //                         </div>
    //                         <div class="form-group col-lg-5">
    //                             <label for="Age" class="form-check-label text-white">Age<span style="color: red">*</span></label>
    //                             <input type="text" class="form-control" id="age" name="child_age[]"
    //                                 placeholder="Age" required>
    //                             @error('age')
    //                                 <span class="error">{{ $message }}</span>
    //                             @enderror
    //                         </div> 
    //                         <div class="form-group col-lg-2">
    //                             <button type="button" class="btn btn-danger remove">x</button>
    //                         </div>
    //                     </div>
    //                 `);
        //     }
        // });
        // $('#infants').on('change', function() {
        //     var count = $(this).val();
        //     for (i = 0; i < count; i++) {
        //         let details = $('#details');
        //         details.append(`
    //                     <div class="row item" >
    //                         <input type="hidden" name="type[]" value="2">
    //                         <div class="form-group col-lg-5" >
    //                             <label for="Name" class="form-check-label text-white">Name<span style="color: red">*</span></label>
    //                             <input type="text" class="form-control" id="name" name="infants_name[]"
    //                                 placeholder="Name" required>
    //                             @error('name')
    //                                 <span class="error">{{ $message }}</span>
    //                             @enderror
    //                         </div>
    //                         <div class="form-group col-lg-5">
    //                             <label for="Age" class="form-check-label text-white">Age<span style="color: red">*</span></label>
    //                             <input type="text" class="form-control" id="age" name="infants_age[]"
    //                                 placeholder="Age" required>
    //                             @error('age')
    //                                 <span class="error">{{ $message }}</span>
    //                             @enderror
    //                         </div> 
    //                         <div class="form-group col-sm-2">
    //                             <button type="button" class="btn btn-danger remove">x</button>
    //                         </div>
    //                     </div>
    //                 `);
        //     }
        // });

        $(document).on("click", ".remove", function(event) {
            alert('Are you sure?');
            $(this).parent().closest(".item").remove();
        });

        $('#location').on('change', function() {
            window.location.href = $(this).val();
        })
        
        function correctCaptcha() {
            $('#submitButton').attr('disabled', false);
        }
        function validateInput(input) {
            // Remove special characters except letters and spaces
            input.value = input.value.replace(/[^a-zA-Z\s]/g, '');
        }
    </script>
@endpush
