@extends('Frontend.layout.master')


@section('page-contents')
    @push('styles')
        <style>
            #map {
                height: 500px;
                /* The height is 400 pixels */
                width: 100%;
                /* The width is the width of the web page */
            }

            .breadcrum1 {
                height: 80px;
                background-color: #063A72;
            }

            .profile-card {
                letter-spacing: 0.025em;
                text-align: center;
                color: #002D40;
                margin-bottom: 40px;
                /* height: 100%; */
                /* position: relative; */
            }

            .profile-card .pic {
                height: 130px;
                width: 130px;
                margin: -100px auto 0 auto;
                border-radius: 50%;
                z-index: 2;
            }

            .profile-card a {
                text-decoration: none;
            }

            .profile-card .pic img {
                height: 100%;
                width: 100%;
                object-fit: cover;
                border-radius: 50%;
            }

            .profile-card .profile {
                /* position: relative; */
                background: #014b9a;
                width: 100%;
                height: 100%;
                margin-bottom: 20px;
                border-radius: 2rem;
               padding-bottom: 30px;
                box-sizing: border-box;
                transition: transform 500ms ease-in-out;
                box-shadow: 0 2px 4px -3px rgba(0, 45, 64, 0.085), 0 0rem 8px 0 rgba(0, 45, 64, 0.1);
            }

            .profile-card .above-fold {
                padding: 15px 10px 0 10px;
                height: 180px;
            }

            .profile-card .above-fold .name {
                font-size: 20px;
                font-weight: 500;
                margin-bottom: 0.4rem;
                color: #fff;
            }

            .profile-card .above-fold .role {
                font-size: 16px;
                font-weight: 400;
                color: #fff;
                /* margin-bottom: 0.8rem; */
            }

            .profile-card .above-fold .location {
                font-size: 16px;
                margin: 10px 0;
                color: #fff;
                font-weight: 600;
            }

            .profile-card .above-fold .location i {
                margin-right: 10px;
            }

            .profile-card.expand .cover {
                opacity: 1;
                transform: translateY(-5rem);
                transition: transform 500ms ease-in-out, opacity 200ms 0ms;
            }

            .profile-card.expand .profile {
                transform: translateY(5rem);
            }

            .profile-card.expand .below-fold {
                max-height: 19em;
                opacity: 1;
            }

            .profile-card.expand #expand-button {
                animation: none;
                transform: rotate(180deg);
            }



            .profile-card .button {
                padding: 1.2rem;
                width: 70%;
                margin: 30px auto 0px auto;
                /* margin: 1rem 0.5rem 0; */
                box-sizing: border-box;
                background: transparent;
                cursor: pointer;
                font-size: 18px;
                line-height: 0;
                font-weight: 500;
                color: #ffffff;
                border: 1px solid#ffffff;
                border-radius: 2rem;
                transition: background 200ms, color 200ms;
            }

            .profile-card .button:hover {
                background: #1e81eb;
                color: white;
            }
            .india-img{
                height: 300px;
                width: 100%;
            }
            .india-img img{
                height: 100%;
                width: 100%;
                object-fit: cover;
                border-radius: 2rem 2rem 0 0;
            }
            
        </style>
    @endpush
    <section class="breadcrum" style="background-image: url({{ asset('Frontend/img/banner/Indian-Tourism-breadcrump.jpg') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>Indian Tourism</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="agent mt-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="row m-0">

                    @foreach ($contents as $content)
                        {{-- <div class="col-lg-4">
                            <div class="profile-card">
                                <div class="profile">
                                    <div class="india-img">
                                        <img src="{{ asset("storage/$content->image") }}" alt="" class="img-fluid">
                                    </div>
                                    <div class="above-fold">
                                        <div class="name  text-white">
                                            {{ $content->destination_name }}
                                        </div>

                                    <div class="text-white">
                                        {!! $content->description !!}
                                    </div>


                                        
                                    </div>
                                    <div class="row">
                                        <a href="{{ route('indian-tourism-form', $content->id) }}">
                                            <div class="button">
                                                Quote Request
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div> --}}

                        <div class="col-lg-6 my-3">
                            <div class="tourism-card">
                                <div class="content">
                                    <div class="picture-wrapper">
                                        <img src="{{ asset("storage/$content->image") }}" class="img-fluid" alt="">
                                    </div>
                                        
                                    <div class="text-wrapper">  
                                        <h1 class="title"> {{ $content->destination_name }}</h1>
                                        
                                        {!! $content->description !!}
                                      
                                    </div>
                                </div>
                                <div class="header-1">
                                    <a href="{{ route('indian-tourism-form', $content->id) }}" class="text-decoration-none"><h2 class="category">Quote Request</h2></a>
                                </div>
                            </div>
                       </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endsection
