<?php

use App\Http\Controllers\Admin\AboutUs\AboutUsController;
use App\Http\Controllers\Admin\Admin\AdminController;
use App\Http\Controllers\Admin\AdminMails\AdminMailController;
use App\Http\Controllers\Admin\BookWithUsInquiry\BookWithUsInquiryController;
use App\Http\Controllers\Admin\Career\CareerQuery;
use App\Http\Controllers\Admin\ContactAgency\ContactAgencyController;
use App\Http\Controllers\Admin\ContactQuery\ContactQueryController;
use App\Http\Controllers\Admin\ContactUs\ContactUsController;
use App\Http\Controllers\Admin\Cruise\CruiseShipOptions;
use App\Http\Controllers\Admin\Cruise\CruiseVacation;
use App\Http\Controllers\Admin\Cruise\TopCruisePageController;
use App\Http\Controllers\Admin\Cruise\TopCruisePort;
use App\Http\Controllers\Admin\Destination\AllDestinationController;
use App\Http\Controllers\Admin\Destination\DestinationController;
use App\Http\Controllers\Admin\Disney\DisneyController;
use App\Http\Controllers\Admin\Flight\FlightController;
use App\Http\Controllers\Admin\FlightForm\FlightFormController;
use App\Http\Controllers\Admin\GroupVacation\GroupVacationController;
use App\Http\Controllers\Admin\Home\HomeAirlines;
use App\Http\Controllers\Admin\Home\HomeBannerController;
use App\Http\Controllers\Admin\Home\HomeController as HomeHomeController;
use App\Http\Controllers\Admin\Home\HomeDestinationForYou;
use App\Http\Controllers\Admin\Home\HomeDestinationForYouLocationController;
use App\Http\Controllers\Admin\Home\HomeImageController;
use App\Http\Controllers\Admin\Home\HomeTestimonialsController;
use App\Http\Controllers\Admin\Hotel\HotelController;
use App\Http\Controllers\Admin\IndianTouristDestination\IndianTouristDestinationController;
use App\Http\Controllers\Admin\InformationLinks\InformationLinksController;
use App\Http\Controllers\Admin\Location\LocationController;
use App\Http\Controllers\Admin\Location\ProvinceController;
use App\Http\Controllers\Admin\Location\TravelLocationController;
use App\Http\Controllers\Admin\Newsletter\NewsletterController;
use App\Http\Controllers\Admin\Service\ServiceController;
use App\Http\Controllers\Admin\Travel\TravelController;
use App\Http\Controllers\Admin\TravelBooking\TravelBookingController;
use App\Http\Controllers\Admin\TravelProfessional\TravelProfessionalController;
use App\Http\Controllers\Admin\UsefulLinks\UsefulLinksController;
use App\Http\Controllers\Admin\Vacation\VacationController;
use App\Http\Controllers\Admin\Wedding\WeddingController;
use App\Http\Controllers\Frontend\ContactUsController as FrontendContactUsController;
use App\Http\Controllers\Frontend\FlightBookingController;
use App\Http\Controllers\Frontend\FooterController;
use App\Http\Controllers\Frontend\Homecontroller;
use App\Http\Controllers\IndianTourismQueryController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ServiceOptionController;
use App\Models\AllDestination;
use App\Models\HomeDestinationForYouLocation;
use App\Models\IndianTouristDestination;
use Illuminate\Support\Facades\Route;
use Monolog\Processor\HostnameProcessor;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Mail;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Home page
Route::get('/', [Homecontroller::class, 'index'])->name('index');
Route::get('/all-packages', [Homecontroller::class, 'allpackages'])->name('allpackages');
Route::get('/indian-tourist-destinations', [Homecontroller::class, 'indian_tourist_destinations'])->name('indian-tourist-destinations');
//Cruises page
Route::get('/cruise-vacation', [Homecontroller::class, 'cruise_vacation'])->name('cruise_vacation');
Route::get('/top-cruise-ports', [Homecontroller::class, 'top_cruise_ports'])->name('top_cruise_ports');
Route::get('/cruise-ship-options', [Homecontroller::class, 'cruise_ship_options'])->name('cruise_ship_options');


Route::get('/ports', [Homecontroller::class, 'ports'])->name('ports');
//wedding page
Route::get('/wedding', [Homecontroller::class, 'wedding'])->name('wedding');
//flights page
Route::get('/flights', [Homecontroller::class, 'flights'])->name('flights');
//vacation page
Route::get('/vacation', [Homecontroller::class, 'vacation'])->name('vacation');
//Travel page
Route::get('/travel', [Homecontroller::class, 'travel'])->name('travel');
Route::get('/travel/{slug}', [Homecontroller::class, 'travel_location'])->name('travel.location');
//Travel booking page
Route::get('/travel-booking', [Homecontroller::class, 'travel_booking'])->name('travel-booking');
//Disney page
Route::get('/disney', [Homecontroller::class, 'disney'])->name('disney');
//hotel page
Route::get('/hotel', [Homecontroller::class, 'hotel'])->name('hotel');
//Group Travel
Route::get('/group-travel', [Homecontroller::class, 'group_vacation'])->name('group-vacation');
//About us page
Route::get('/about-us', [Homecontroller::class, 'aboutus'])->name('about-us');
//services page
Route::get('/services', [Homecontroller::class, 'services'])->name('service');
//contact us page
Route::get('/contact-us', [FrontendContactUsController::class, 'contact_us'])->name('contact-us-page');
Route::post('/contact-us-query', [FrontendContactUsController::class, 'contact_us_query'])->name('contact-us-query');
Route::post('/contact-agency', [FrontendContactUsController::class, 'contact_agency'])->name('contact-agency');


Route::get('useful-links', [FooterController::class, 'useful_links'])->name('footer-useful-links');
Route::get('/useful-links/{slug}', [FooterController::class, 'useful_link_pages'])->name('useful-links');

Route::get('information-links', [FooterController::class, 'information_links'])->name('footer-information-links');
Route::get('/information-links/{slug}', [FooterController::class, 'information_link_pages'])->name('information-links');

Route::get('all-destinations', [FooterController::class, 'all_destinations'])->name('all_destinations');
Route::get('destinations', [FooterController::class, 'destinations'])->name('destinations');
Route::get('destinations-links/{slug}', [FooterController::class, 'destinations_link_pages'])->name('destinations-links');


Route::get('/map_locations', [HomeController::class, 'map_locations'])->name('map_locations');
Route::get('/locations', [HomeController::class, 'locations'])->name('locations');
Route::get('/location-detail/{slug}', [HomeController::class, 'location_detail'])->name('location_detail');

Route::post('flight-booking', [FlightBookingController::class, 'store'])->name('flight-booking');
Route::get('book-with-me/{id}', [FlightBookingController::class, 'index'])->name('book-with-me');
Route::get('indian-tourism-form/{id}', [IndianTouristDestinationController::class, 'indian_tourism_form'])->name('indian-tourism-form');
Route::get('indian-tourism-form-page/{id}', [IndianTouristDestinationController::class, 'indian_tourism_form_page'])->name('indian-tourism-form-page');
Route::post('indian-tourism-form-submit', [IndianTouristDestinationController::class, 'indian_tourism_form_submit'])->name('indian-tourism-form-submit');
Route::get('booking-forms/{page_name}', [Homecontroller::class, 'booking_forms'])->name('booking-forms');
Route::post('booking-forms-submit', [Homecontroller::class, 'booking_forms_submit'])->name('booking-forms-submit');

// ------
Route::get('book/cruise-vacation', [Homecontroller::class, 'cruiseVacationForm'])->name('cruise-vacation.booking');
Route::get('book/wedding', [Homecontroller::class, 'weddingBookingForm'])->name('wedding.booking');
Route::get('book/vacation', [Homecontroller::class, 'vacationForm'])->name('vacation.booking');

Route::get('booking-pacakage-forms/{id}', [Homecontroller::class, 'booking_pacakage_forms'])->name('booking-pacakage-forms');
Route::get('booking-package-forms-page', [Homecontroller::class, 'booking_package_forms_page'])->name('booking-package-forms-page');
Route::get('booking-package-forms-submit', [Homecontroller::class, 'booking_package_forms_submit'])->name('booking-package-forms-submit');


Route::post('newsletter', [NewsletterController::class, 'store'])->name('newsletter.store');
// Route::resource('newsletter', NewsletterController::class);


//Career page
Route::get('/career-page', [Homecontroller::class, 'career_page'])->name('career-page');
Route::post('/career', [Homecontroller::class, 'career_form'])->name('career');


Route::get('/dashboard', function () {
    return view('Admin.dashboard.index');
})->middleware(['auth', 'verified'])->name('dashboard');


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::group(['prefix' => 'admin', 'as' => 'admin.'], function () {

    Route::get('/login', function () {
        return view('auth.login');
    })->name('login');

    Route::group(['middleware' => ['auth']], function () {
        Route::group(['middleware' => ['auth']], function () {
            Route::resource('company', DestinationController::class);
            Route::resource('admin', AdminController::class);
            Route::resource('home', HomeHomeController::class);
            Route::resource('home-banner', HomeBannerController::class);
            Route::resource('home-image', HomeImageController::class);
            Route::resource('home-airlines', HomeAirlines::class);
            Route::resource('home-testimonials', HomeTestimonialsController::class);
            Route::resource('home-destination-for-you-section', HomeDestinationForYouLocationController::class);
            Route::resource('home-destination-for-you', HomeDestinationForYou::class);
            Route::resource('cruises-ship-options', CruiseShipOptions::class);
            Route::resource('cruises-vacations', CruiseVacation::class);
            Route::resource('top-cruise-page', TopCruisePageController::class);
            Route::resource('top-cruise-ports', TopCruisePort::class);
            Route::resource('flight', FlightController::class);
            Route::resource('hotel', HotelController::class);
            Route::resource('travel', TravelController::class);
            Route::resource('travel-booking', TravelBookingController::class);
            Route::resource('vacation', VacationController::class);
            Route::resource('disney', DisneyController::class);
            Route::resource('wedding', WeddingController::class);
            Route::resource('group-vacation', GroupVacationController::class);
            Route::resource('about-us', AboutUsController::class);
            Route::resource('service', ServiceController::class);
            Route::resource('contact-us', ContactUsController::class);
            Route::resource('contact-us-query', ContactQueryController::class);
            Route::get('contact-us-query-export', [ContactQueryController::class, 'export'])->name('contact-us-query-export');
            Route::resource('useful-links', UsefulLinksController::class);
            Route::resource('information-links', InformationLinksController::class);
            Route::resource('destination', DestinationController::class);
            Route::resource('location', LocationController::class);
            Route::resource('travel-professionals', TravelProfessionalController::class);
            Route::resource('all-destination', AllDestinationController::class);
            Route::resource('indian-tourism', IndianTouristDestinationController::class);
            Route::resource('indian-tourism-query', IndianTourismQueryController::class);
            Route::resource('admin-mails', AdminMailController::class);
            Route::resource('careers', CareerQuery::class);
            Route::get('career-export', [CareerQuery::class, 'export'])->name('career-export');
            Route::resource('book-with-us-inquiry', BookWithUsInquiryController::class);
            Route::get('bookwithus-export', [BookWithUsInquiryController::class, 'export'])->name('bookwithus-export');
            Route::resource('newsletter', NewsletterController::class);
            Route::get('newsletter-export', [NewsletterController::class, 'export'])->name('newsletter-export');
            Route::resource('contact-agency', ContactAgencyController::class);
            Route::get('contact-agency-export', [ContactAgencyController::class, 'export'])->name('contact-agency-export');
            Route::resource('flight-forms', FlightFormController::class);
            Route::get('flight-form-export', [FlightFormController::class, 'export'])->name('flight-form-export');

            // service options
            Route::get('service-options', [ServiceOptionController::class, 'index'])->name('service-options');
            Route::get('service-option/create', [ServiceOptionController::class, 'create'])->name('service-option.create');
            Route::post('service-option/create', [ServiceOptionController::class, 'store']);
            Route::get('service-option/{id}/edit', [ServiceOptionController::class, 'edit'])->name('service-option.edit');
            Route::post('service-option/{id}/edit', [ServiceOptionController::class, 'update']);
            Route::get('service-option/{id}/delete', [ServiceOptionController::class, 'destroy'])->name('service-option.delete');
        
            // Province
            Route::resource('province', ProvinceController::class);

            //Travel Location
            Route::get('travel-location', [TravelLocationController::class, 'index'])->name('travel-location.index');
            Route::get('travel-location/create', [TravelLocationController::class, 'create'])->name('travel-location.create');
            Route::post('travel-location/create', [TravelLocationController::class, 'store']);
            Route::get('travel-location/{id}/edit', [TravelLocationController::class, 'edit'])->name('travel-location.edit');
            Route::post('travel-location/{id}/edit', [TravelLocationController::class, 'update']);
        });
    });
});

Route::get('/clear-cache', function () {
    Artisan::call('optimize:clear');
    return 'Cache cleared!';
});
Route::get('/send-mail-test', function () {
    $toEmail = 'dhruba@webomindapps.com'; // Replace with the recipient's email address
    $subject = 'Test Email';
    $message = 'This is a test email sent from Gill Travel.';

    Mail::raw($message, function ($mail) use ($toEmail, $subject) {
        $mail->to($toEmail)
             ->subject($subject);
    });

    return 'Test email sent successfully!';
});
require __DIR__ . '/auth.php';
