

<?php $__env->startSection('page-contents'); ?>
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Home Page Banners </h1>
    </div>
    <div>
        <a class="btn btn-danger btn-sm" href="<?php echo e(route('admin.home-banner.create')); ?>">
            Add
        </a>
    </div>
    <div class="table-detail">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Banner</th>
                    <th scope="col">Title</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th scope="row"><?php echo e($banners->firstItem() + $index); ?></th>
                        <td><img src="<?php echo e(asset("storage/$banner->banner")); ?>"></td>

                        <td><?php echo e($banner->title); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.home-banner.edit', $banner->id)); ?>">
                                <i class="fas fa-edit"></i>
                            </a>
                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                <a class="deleteRecord" data-id="form-submit-<?php echo e($banner->id); ?>"
                                    data-route="<?php echo e(route('admin.home-banner.destroy', $banner->id)); ?>">
                                    <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                </a>
                                <form method="POST" id="form-submit-<?php echo e($banner->id); ?>"
                                    action="<?php echo e(route('admin.home-banner.destroy', $banner->id)); ?>" hidden>
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>
                                    <button type="submit"><i class="fas fa-trash"></i></button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(session()->has('message')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session()->get('message')); ?>

                    </div>
                <?php endif; ?>
            </tbody>
        </table>
        <?php echo e($banners->links('pagination::bootstrap-4')); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $('.deleteRecord').on('click', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this?')) {
                $('#' + id + '').submit();
            }
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwwgilltravel/public_html/resources/views/Admin/HomeBanner/index.blade.php ENDPATH**/ ?>