

<?php $__env->startSection('page-contents'); ?>
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Contact Us Inquery</h1>
    </div>

    <form action="" method="GET" style="padding: 0px">
        <div class="row">
            <div class="col-lg-2">
                <input type="text" class="form-control" name="search" placeholder="Search">
            </div>
            <div class="col-lg-3">
                <select name="service_type" class="form-control" id="service_type" class="c-select">
                    <option value="">Select Service Type</option>
                    <option value="Flights" id="Flights">
                        Flights </option>
                    <option value="Cruises" id="Cruises">
                        Cruises </option>
                    <option value="Destination Wedding" id="DestinationWedding">
                        Destination Wedding </option>
                    <option value="Vacation" id="Vacation">
                        Vacation </option>
                    <option value="Travel" id="Travel">
                        Travel </option>
                    <option value="Group travel" id="GroupTravel">
                        Group travel </option>

                    <option value="Indian Tourism" id="IndianTourism">
                        Indian Tourism </option>

                    <option value="Others" id="Others">
                        Others </option>

                </select>
            </div>
            <div class="col-lg-2">
                <input type="submit" class="btnSearch" value="Search">
            </div>
            <div class="col-lg-2 ml-auto">
                <a href="<?php echo e('contact-us-query-export'); ?>" class="btnSearch"><i
                        class="fas fa-download fa-sm text-white-50"></i>
                    Download</a>
            </div>
        </div>
    </form>
    <div class="row">
        <div class="table-detail">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Service type</th>
                        <th scope="col">First Name</th>
                        <th scope="col">Last Name</th>
                        <th scope="col">Phone Number</th>
                        <th scope="col">Email</th>
                        <th scope="col">Action</th>

                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $enquiries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $enquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th scope="row"><?php echo e($enquiries->firstItem() + $index); ?></th>
                            <td><?php echo e($enquiry->service_type); ?></td>
                            <td><?php echo e($enquiry->first_name); ?></td>
                            <td><?php echo e($enquiry->last_name); ?></td>
                            <td><?php echo e($enquiry->phone_number); ?></td>
                            <td><?php echo e($enquiry->email); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.contact-us-query.show', $enquiry->id)); ?>">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super Admin')): ?>
                                    <a class="deleteRecord" data-id="form-submit-<?php echo e($enquiry->id); ?>"
                                        data-route="<?php echo e(route('admin.contact-us-query.destroy', $enquiry->id)); ?>">
                                        <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                    </a>
                                    <form method="POST" id="form-submit-<?php echo e($enquiry->id); ?>"
                                        action="<?php echo e(route('admin.contact-us-query.destroy', $enquiry->id)); ?>" hidden>
                                        <?php echo method_field('DELETE'); ?>
                                        <?php echo csrf_field(); ?>
                                        <button type="submit"><i class="fas fa-trash"></i></button>
                                    </form>
                                <?php endif; ?>


                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if(session()->has('message')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session()->get('message')); ?>

                        </div>
                    <?php endif; ?>
                </tbody>
            </table>
            <?php echo e($enquiries->links('pagination::bootstrap-4')); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $('.deleteRecord').on('click', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this?')) {
                $('#' + id + '').submit();
            }
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwwgilltravel/public_html/resources/views/Admin/ContactQuery/index.blade.php ENDPATH**/ ?>