

<?php $__env->startSection('title'); ?>
    <title><?php echo e($travel->meta_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
    <meta name="description" content="<?php echo e($travel->meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
    <meta name="keywords" content="<?php echo e($travel->meta_keywords); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-contents'); ?>
    <?php $__env->startPush('scripts'); ?>
        <style>
            .advertisers-service-sec span {
                color: #f67900;
            }

            .advertisers-service-sec .box-main {
                padding: 0 1em 1em 1em;
                text-align: center;
            }

            .advertisers-service-sec .service-card {
                width: 100%;
                height: 100%;
                padding: 1em 1em;
                border-radius: 5px;
                box-shadow: 0 0 35px rgba(0, 0, 0, 0.12);
                cursor: pointer;
                transition: 0.5s;
                position: relative;
                z-index: 2;
                overflow: hidden;
                background: #fff;
            }

            .advertisers-service-sec .service-card::after {
                content: "";
                width: 100%;
                height: 100%;
                background: linear-gradient(#013976, #409cff);
                position: absolute;
                left: 0%;
                top: -98%;
                z-index: -2;
                transition: all 0.4s cubic-bezier(0.77, -0.04, 0, 0.99);
            }

            .advertisers-service-sec h3 {
                font-size: 15px;
                text-transform: capitalize;
                font-weight: 600;
                color: #1f194c;
                margin: .5em 0;
                z-index: 3;
            }

            .advertisers-service-sec p {
                color: #575a7b;
                font-size: 15px;
                line-height: 1.6;
                letter-spacing: 0.03em;
                z-index: 3;
            }

            .advertisers-service-sec .icon-wrapper {
                background-color: #2c7bfe;
                position: relative;
                margin: auto;
                font-size: 20px;
                height: 2.5em;
                width: 2.5em;
                color: #ffffff;
                border-radius: 50%;
                display: grid;
                place-items: center;
                transition: 0.5s;
                z-index: 3;
            }

            .advertisers-service-sec .service-card:hover:after {
                top: 0%;
            }
            .advertisers-service-sec a{
                text-decoration: none;
            }
        </style>
    <?php $__env->stopPush(); ?>
    <section class="breadcrum" style="background-image: url(<?php echo e(asset("storage/$travel->banner")); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1><?php echo e($travel->title); ?></h1>
                </div>
            </div>
        </div>
    </section>

    <section class="book-view">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 my-auto">
                    <h2 class="text-white">Discover, explore, and book your next adventure with us today !</h2>
                </div>
                <div class="col-lg-4 my-auto ms-auto">
                    <a href="<?php echo e(route('booking-forms', ['page_name' => $travel->title])); ?>" class="text-decoration-none">
                        <button class="book-now">
                            <span class="text">Book with us</span>
                            <span class="icon">
                                <svg aria-hidden="true" width="20px" data-icon="paper-plane"
                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path fill="currentColor"
                                        d="M476 3.2L12.5 270.6c-18.1 10.4-15.8 35.6 2.2 43.2L121 358.4l287.3-253.2c5.5-4.9 13.3 2.6 8.6 8.3L176 407v80.5c0 23.6 28.5 32.9 42.5 15.8L282 426l124.6 52.2c14.2 6 30.4-2.9 33-18.2l72-432C515 7.8 493.3-6.8 476 3.2z">
                                    </path>
                                </svg>
                            </span>
                        </button>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="ptb group-section">
        <div class="container">
            <div class="row">

                <div class="mb-5">
                    <a href=<?php echo e(route('index')); ?> class="back-button">Back to home <i class="fa fa-arrow-left"></i></a>
                </div>

                <div class="col-lg-6 col-md-6 my-auto col-sm-12">
                    <div class="content px-4">
                        <h1 class="mb-4"><?php echo e($travel->title); ?> </h1>
                        <p style="font-size: 16px;">
                            <?php echo $travel->description; ?>


                        </p>
                    </div>
                </div>

                <div class="col-lg-6 mx-auto col-md-6 col-sm-12">
                    <img src="<?php echo e(asset("storage/$travel->image")); ?>" class="img-fluid" alt="">
                </div>

            </div>
        </div>

        <div class="container mt-5">
            <div class="row advertisers-service-sec g-3">
                <div class="col-12">
                    <h2 class="mb-3">Areas We Services Across GTA & Other Provinces.</h2>
                </div>
                <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-3 box-main">
                        <a href="<?php echo e(route('travel.location', $location->url_key)); ?>">
                            <div class="service-card">
                                <div class="icon-wrapper">
                                    <i class="fa fa-map-marker"></i>
                                </div>
                                <h3><?php echo e($location->location_name); ?></h3>
                                <a class="button-sm text-decoration-none"
                                    href="<?php echo e(route('travel.location', $location->url_key)); ?>">
                                    Book Your Travel
                                </a>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwwgilltravel/public_html/resources/views/Frontend/Pages/Travel/travel.blade.php ENDPATH**/ ?>