

<?php $__env->startSection('title'); ?>
    <title><?php echo e($content->meta_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
    <meta name="description" content="<?php echo e($content->meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
    <meta name="keywords" content="<?php echo e($content->meta_keywords); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-contents'); ?>
    <section class="breadcrum" style="background-image: url(<?php echo e(asset("storage/$content->banner")); ?>); ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>Destinations</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="ptb bg-light">
        <div class="container">
            <div class="row">

                <div class="col-lg-6 col-md-6 my-auto col-sm-12">
                    <div class="content px-4">
                        <h1 class="mb-4"> <?php echo e($content->title); ?></h1>
                        <?php echo $content->description; ?>

                    </div>
                </div>
                <div class="col-lg-6 mx-auto text-center col-md-6 col-sm-12">
                    <img src="<?php echo e(asset("storage/$content->image")); ?>" class="img-fluid" alt="">
                </div>
            </div>
        </div>
    </section>

    <div class="tour-wrap ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12" id="Croatia">
                    <?php $__currentLoopData = $destinations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $destination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="feature-tour-card style2">

                            <div class="row gx-0">
                                <div class="col-lg-4 col-md-4 col-sm-12">
                                    <div class="destination-img">
                                        <img src="<?php echo e(asset("storage/$destination->destination_image")); ?>" class="img-fluid"
                                            alt="">
                                    </div>
                                </div>
                                <div class="col-lg-8 col-md-8 my-auto col-sm-12">
                                    <div class="feature-tour-info">
                                        <h4><?php echo e($destination->title); ?></h4>
                                        <?php echo $destination->destination_description; ?>


                                        <div class="row">
                                            <div class="col-lg-3">
                                                <a href="<?php echo e(route('destinations-links', $destination->slug)); ?>"
                                                    class="read-more-btn">
                                                    <span>Read more</span>
                                                    <svg width="34" height="34" viewBox="0 0 74 74" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <circle cx="37" cy="37" r="35.5" stroke="white"
                                                            stroke-width="3"></circle>
                                                        <path
                                                            d="M25 35.5C24.1716 35.5 23.5 36.1716 23.5 37C23.5 37.8284 24.1716 38.5 25 38.5V35.5ZM49.0607 38.0607C49.6464 37.4749 49.6464 36.5251 49.0607 35.9393L39.5147 26.3934C38.9289 25.8076 37.9792 25.8076 37.3934 26.3934C36.8076 26.9792 36.8076 27.9289 37.3934 28.5147L45.8787 37L37.3934 45.4853C36.8076 46.0711 36.8076 47.0208 37.3934 47.6066C37.9792 48.1924 38.9289 48.1924 39.5147 47.6066L49.0607 38.0607ZM25 38.5L48 38.5V35.5L25 35.5V38.5Z"
                                                            fill="white"></path>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwwgilltravel/public_html/resources/views/Frontend/FooterPages/AllDestinations.blade.php ENDPATH**/ ?>